/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.EitherManyCodec;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.stream.DoubleStream;
import net.minecraft.class_5253;

public class Color {
    public static final NamedMapCodec<Color> MAP_CODEC = NamedCodec.record(colorInstance -> colorInstance.group(NamedCodec.FLOAT.optionalFieldOf("alpha", Float.valueOf(1.0f)).forGetter(color -> Float.valueOf((float)color.getAlpha() / 255.0f)), NamedCodec.FLOAT.optionalFieldOf("red", Float.valueOf(1.0f)).forGetter(color -> Float.valueOf((float)color.getRed() / 255.0f)), NamedCodec.FLOAT.optionalFieldOf("green", Float.valueOf(1.0f)).forGetter(color -> Float.valueOf((float)color.getGreen() / 255.0f)), NamedCodec.FLOAT.optionalFieldOf("blue", Float.valueOf(1.0f)).forGetter(color -> Float.valueOf((float)color.getBlue() / 255.0f))).apply((Applicative)colorInstance, Color::fromColors), "Color");
    public static final NamedCodec<Color> ARRAY_CODEC = NamedCodec.DOUBLE_STREAM.comapFlatMap(stream -> Codecs.validateDoubleStreamSize(stream, 4).map(array -> Color.fromColors(array[0], array[1], array[2], array[3])), color -> DoubleStream.of((float)color.getAlpha() / 255.0f, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f), "Color");
    public static final NamedCodec<Color> CODEC = EitherManyCodec.of(MAP_CODEC, ARRAY_CODEC, NamedCodec.intRange(0, Integer.MAX_VALUE).xmap(Color::fromARGB, Color::getARGB, ""));
    public static final Color WHITE = Color.fromColors(255, 255, 255, 255);
    public static final Color TRANSPARENT_WHITE = Color.fromColors(127, 255, 255, 255);
    private final int alpha;
    private final int red;
    private final int green;
    private final int blue;

    public static Color fromARGB(int colorARGB) {
        return new Color(class_5253.class_5254.method_27762((int)colorARGB), class_5253.class_5254.method_27765((int)colorARGB), class_5253.class_5254.method_27766((int)colorARGB), class_5253.class_5254.method_27767((int)colorARGB));
    }

    public static Color fromColors(int alpha, int red, int green, int blue) {
        return new Color(alpha, red, green, blue);
    }

    public static Color fromColors(float alpha, float red, float green, float blue) {
        return Color.fromColors((int)(alpha * 255.0f), (int)(red * 255.0f), (int)(green * 255.0f), (int)(blue * 255.0f));
    }

    public static Color fromColors(double alpha, double red, double green, double blue) {
        return Color.fromColors((int)(alpha * 255.0), (int)(red * 255.0), (int)(green * 255.0), (int)(blue * 255.0));
    }

    private Color(int alpha, int red, int green, int blue) {
        this.alpha = alpha;
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getARGB() {
        return class_5253.class_5254.method_27764((int)this.alpha, (int)this.red, (int)this.green, (int)this.blue);
    }
}

