/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.guielement.TextGuiElement;
import fr.frinn.custommachinery.impl.codec.EnhancedEitherCodec;
import fr.frinn.custommachinery.impl.codec.EnhancedListCodec;
import fr.frinn.custommachinery.impl.codec.EnumCodec;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2522;

public class Codecs {
    public static final NamedCodec<class_2487> COMPOUND_NBT_CODEC = NamedCodec.STRING.comapFlatMap(Codecs::decodeCompoundNBT, class_2487::toString, "NBT");
    public static final NamedCodec<TextGuiElement.Alignment> ALIGNMENT_CODEC = Codecs.fromEnum(TextGuiElement.Alignment.class);
    public static final NamedCodec<ProgressBarGuiElement.Orientation> PROGRESS_DIRECTION = Codecs.fromEnum(ProgressBarGuiElement.Orientation.class);
    public static final NamedCodec<class_2338> BLOCK_POS = NamedCodec.of(class_2338.field_25064, "Block Position");
    public static final NamedCodec<class_238> AABB_CODEC = NamedCodec.DOUBLE_STREAM.comapFlatMap(stream -> Codecs.validateDoubleStreamSize(stream, 6).map(array -> new class_238(array[0], array[1], array[2], array[3], array[4], array[5])), box -> DoubleStream.of(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324), "Box");
    public static final NamedCodec<class_238> BOX_CODEC = Codecs.either(BLOCK_POS, AABB_CODEC, "Box").xmap(either -> (class_238)either.map(pos -> new class_238(pos, pos), Function.identity()), Either::right, "Box");

    public static <E extends Enum<E>> NamedCodec<E> fromEnum(Class<E> enumClass) {
        return EnumCodec.of(enumClass);
    }

    public static <F, S> NamedCodec<Either<F, S>> either(NamedCodec<F> first, NamedCodec<S> second, String name) {
        return EnhancedEitherCodec.of(first, second, name);
    }

    public static <T> NamedCodec<List<T>> list(NamedCodec<T> codec) {
        return EnhancedListCodec.of(codec);
    }

    private static DataResult<class_2487> decodeCompoundNBT(String encoded) {
        try {
            return DataResult.success((Object)class_2522.method_10718((String)encoded));
        }
        catch (CommandSyntaxException e) {
            return DataResult.error((String)("Not a valid NBT: " + encoded + " " + e.getMessage()));
        }
    }

    public static DataResult<double[]> validateDoubleStreamSize(DoubleStream stream, int size) {
        double[] array = stream.limit(size + 1).toArray();
        if (array.length != size) {
            String s = "Input is not a list of " + size + " doubles";
            return array.length >= size ? DataResult.error((String)s, (Object)Arrays.copyOf(array, size)) : DataResult.error((String)s);
        }
        return DataResult.success((Object)array);
    }
}

