/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2694;
import net.minecraft.class_4538;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BlockStructure {
    private final Map<class_2338, IIngredient<PartialBlockState>> blocks_north;
    private final Map<class_2338, IIngredient<PartialBlockState>> blocks_east;
    private final Map<class_2338, IIngredient<PartialBlockState>> blocks_south;
    private final Map<class_2338, IIngredient<PartialBlockState>> blocks_west;

    public BlockStructure(Map<class_2338, IIngredient<PartialBlockState>> blocks) {
        this.blocks_south = blocks;
        this.blocks_west = this.rotate(blocks, class_2470.field_11463);
        this.blocks_north = this.rotate(blocks, class_2470.field_11464);
        this.blocks_east = this.rotate(blocks, class_2470.field_11465);
    }

    public Map<class_2338, IIngredient<PartialBlockState>> getBlocks(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> this.blocks_south;
            case class_2350.field_11034 -> this.blocks_east;
            case class_2350.field_11039 -> this.blocks_west;
            default -> this.blocks_north;
        };
    }

    public boolean match(class_4538 world, class_2338 machinePos, class_2350 machineFacing) {
        Map<class_2338, IIngredient<PartialBlockState>> blocks = this.getBlocks(machineFacing);
        class_2338.class_2339 worldPos = new class_2338.class_2339();
        for (class_2338 pos : blocks.keySet()) {
            IIngredient<PartialBlockState> ingredient = blocks.get(pos);
            worldPos.method_10103(pos.method_10263() + machinePos.method_10263(), pos.method_10264() + machinePos.method_10264(), pos.method_10260() + machinePos.method_10260());
            class_2694 info = new class_2694(world, (class_2338)worldPos, false);
            if (!ingredient.getAll().stream().noneMatch(state -> state.test(info))) continue;
            return false;
        }
        return true;
    }

    private Map<class_2338, IIngredient<PartialBlockState>> rotate(Map<class_2338, IIngredient<PartialBlockState>> blocks, class_2470 rotation) {
        HashMap<class_2338, IIngredient<PartialBlockState>> rotated = new HashMap<class_2338, IIngredient<PartialBlockState>>();
        blocks.forEach((pos, ingredient) -> {
            if (ingredient instanceof BlockIngredient) {
                rotated.put(pos.method_10070(rotation), new BlockIngredient(((PartialBlockState)ingredient.getAll().get(0)).rotate(rotation)));
            } else {
                rotated.put(pos.method_10070(rotation), (IIngredient<PartialBlockState>)ingredient);
            }
        });
        return rotated;
    }

    public static class Builder {
        private static final Joiner COMMA_JOIN = Joiner.on((String)",");
        private final List<String[]> depth = Lists.newArrayList();
        private final Map<Character, IIngredient<PartialBlockState>> symbolMap = Maps.newHashMap();
        private int aisleHeight;
        private int rowWidth;

        private Builder() {
            this.symbolMap.put(Character.valueOf(' '), BlockIngredient.ANY);
            this.symbolMap.put(Character.valueOf('m'), BlockIngredient.MACHINE);
        }

        public Builder aisle(String ... aisle) {
            if (!ArrayUtils.isEmpty((Object[])aisle) && !StringUtils.isEmpty((CharSequence)aisle[0])) {
                if (this.depth.isEmpty()) {
                    this.aisleHeight = aisle.length;
                    this.rowWidth = aisle[0].length();
                }
                if (aisle.length != this.aisleHeight) {
                    throw new IllegalArgumentException("Expected aisle with height of " + this.aisleHeight + ", but was given one with a height of " + aisle.length + ")");
                }
                for (String s : aisle) {
                    if (s.length() != this.rowWidth) {
                        throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.rowWidth + ", found one with " + s.length() + ")");
                    }
                    for (char c0 : s.toCharArray()) {
                        if (this.symbolMap.containsKey(Character.valueOf(c0))) continue;
                        this.symbolMap.put(Character.valueOf(c0), null);
                    }
                }
                this.depth.add(aisle);
                return this;
            }
            throw new IllegalArgumentException("Empty pattern for aisle");
        }

        public static Builder start() {
            return new Builder();
        }

        public Builder where(char symbol, IIngredient<PartialBlockState> blockMatcher) {
            this.symbolMap.put(Character.valueOf(symbol), blockMatcher);
            return this;
        }

        public BlockStructure build() {
            this.checkMissingPredicates();
            class_2338 machinePos = this.getMachinePos();
            HashMap<class_2338, IIngredient<PartialBlockState>> blocks = new HashMap<class_2338, IIngredient<PartialBlockState>>();
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        blocks.put(new class_2338(k - machinePos.method_10263(), i - machinePos.method_10264(), j - machinePos.method_10260()), this.symbolMap.get(Character.valueOf(this.depth.get(i)[j].charAt(k))));
                    }
                }
            }
            return new BlockStructure(blocks);
        }

        private class_2338 getMachinePos() {
            class_2338 machinePos = null;
            for (int i = 0; i < this.depth.size(); ++i) {
                for (int j = 0; j < this.aisleHeight; ++j) {
                    for (int k = 0; k < this.rowWidth; ++k) {
                        if (this.depth.get(i)[j].charAt(k) != 'm') continue;
                        if (machinePos == null) {
                            machinePos = new class_2338(k, i, j);
                            continue;
                        }
                        throw new IllegalStateException("The structure pattern need exactly one 'm' character to defined the machine position, several found !");
                    }
                }
            }
            if (machinePos != null) {
                return machinePos;
            }
            throw new IllegalStateException("You need to define the machine position in the structure with character 'm'");
        }

        private void checkMissingPredicates() {
            ArrayList list = Lists.newArrayList();
            for (Map.Entry<Character, IIngredient<PartialBlockState>> entry : this.symbolMap.entrySet()) {
                if (entry.getValue() != null) continue;
                list.add(entry.getKey());
            }
            if (!list.isEmpty()) {
                throw new IllegalStateException("Blocks for character(s) " + COMMA_JOIN.join((Iterable)list) + " are missing");
            }
        }
    }
}

