/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.platform.Platform;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.apache.logging.log4j.Logger;

public class UpgradesCustomReloadListener
extends CustomJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final String MAIN_PACKNAME = "main";

    public UpgradesCustomReloadListener() {
        super("upgrades");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        Logger logger = ICustomMachineryAPI.INSTANCE.logger();
        ArrayList<MachineUpgrade> upgrades = new ArrayList<MachineUpgrade>();
        logger.info("Reading Custom Machinery Upgrades json");
        map.forEach((id, json) -> {
            String packName;
            try {
                packName = resourceManager.method_14486(new class_2960(id.method_12836(), "upgrades/" + id.method_12832() + ".json")).method_14480();
            }
            catch (IOException e) {
                packName = MAIN_PACKNAME;
            }
            logger.info("Parsing upgrade json: {} in datapack: {}", id, (Object)packName);
            if (!json.isJsonObject()) {
                logger.error("Bad upgrade JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            DataResult<MachineUpgrade> result = MachineUpgrade.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                MachineUpgrade upgrade = (MachineUpgrade)result.result().get();
                if (upgrade.getItem() == class_1802.field_8162) {
                    logger.error("Invalid item: {}, defined for upgrade: {}", (Object)class_2378.field_11142.method_10221((Object)upgrade.getItem()), id);
                    return;
                }
                logger.info("Successfully parsed upgrade json: {}", id);
                upgrades.add(upgrade);
                return;
            }
            if (result.error().isPresent()) {
                logger.error("Error while parsing upgrade json: {}, skipping...\n{}", id, (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            throw new IllegalStateException("No success nor error when parsing machine json: " + id + ". This can't happen.");
        });
        if (upgrades.size() != 0) {
            logger.info("Successfully parsed {} upgrade json.", (Object)upgrades.size());
        } else {
            logger.info("No machine upgrade json found.");
        }
        if (Platform.isModLoaded((String)"kubejs")) {
            logger.info("Collecting machine upgrades with kubeJS.");
            List<MachineUpgrade> kubejsUpgrades = KubeJSIntegration.collectMachineUpgrades();
            if (kubejsUpgrades.size() != 0) {
                logger.info("Successfully added {} machine upgrades with kubejs", (Object)kubejsUpgrades.size());
            } else {
                logger.info("No machine upgrades found with kubejs");
            }
            upgrades.addAll(kubejsUpgrades);
        }
        logger.info("Finished creating custom machine upgrades.");
        CustomMachinery.UPGRADES.refresh(upgrades);
    }
}

