/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public class Upgrades {
    private List<MachineUpgrade> upgrades = Collections.emptyList();
    private Map<class_1792, List<MachineUpgrade>> upgradesByItem = Collections.emptyMap();
    private Map<class_2960, List<MachineUpgrade>> upgradesByMachine = Collections.emptyMap();

    public void refresh(List<MachineUpgrade> upgrades) {
        this.upgrades = Collections.unmodifiableList(upgrades);
        this.upgradesByItem = upgrades.stream().collect(Collectors.groupingBy(MachineUpgrade::getItem));
        this.upgradesByMachine = upgrades.stream().flatMap(upgrade -> upgrade.getMachines().stream()).distinct().collect(Collectors.toMap(Function.identity(), id -> upgrades.stream().filter(upgrade -> upgrade.getMachines().contains(id)).toList()));
    }

    public void addUpgrade(MachineUpgrade upgrade) {
        ArrayList<MachineUpgrade> upgrades = new ArrayList<MachineUpgrade>(this.upgrades);
        upgrades.add(upgrade);
        this.refresh(upgrades);
    }

    public List<MachineUpgrade> getAllUpgrades() {
        return this.upgrades;
    }

    public List<MachineUpgrade> getUpgradesForItem(class_1792 item) {
        return this.upgradesByItem.getOrDefault(item, Collections.emptyList());
    }

    public List<MachineUpgrade> getUpgradesForMachine(class_2960 machineID) {
        return this.upgradesByMachine.getOrDefault(machineID, Collections.emptyList());
    }

    public List<MachineUpgrade> getUpgradesForItemAndMachine(class_1792 item, class_2960 machineID) {
        return this.getUpgradesForItem(item).stream().filter(upgrade -> this.getUpgradesForMachine(machineID).contains(upgrade)).toList();
    }
}

