/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.TimeMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import fr.frinn.custommachinery.impl.util.IntRange;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class TimeRequirement
extends AbstractRequirement<TimeMachineComponent>
implements IDisplayInfoRequirement {
    public static final NamedCodec<TimeRequirement> CODEC = NamedCodec.record(timeRequirementInstance -> timeRequirementInstance.group(IntRange.CODEC.fieldOf("range").forGetter(requirement -> requirement.range)).apply((Applicative)timeRequirementInstance, TimeRequirement::new), "Time requirement");
    private final IntRange range;

    public TimeRequirement(IntRange range) {
        super(RequirementIOMode.INPUT);
        this.range = range;
    }

    @Override
    public RequirementType<TimeRequirement> getType() {
        return (RequirementType)((Object)Registration.TIME_REQUIREMENT.get());
    }

    @Override
    public boolean test(TimeMachineComponent component, ICraftingContext context) {
        return this.range.contains((int)component.getTime());
    }

    @Override
    public CraftingResult processStart(TimeMachineComponent component, ICraftingContext context) {
        if (this.test(component, context)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.time.error"));
    }

    @Override
    public CraftingResult processEnd(TimeMachineComponent component, ICraftingContext context) {
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<TimeMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.TIME_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.time.info").method_27692(class_124.field_1075));
        this.range.getRestrictions().forEach(restriction -> info.addTooltip((class_2561)new class_2585("* " + restriction.toFormattedString())));
        info.setItemIcon(class_1802.field_8557);
    }
}

