/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.EntityMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class EntityRequirement
extends AbstractDelayedChanceableRequirement<EntityMachineComponent>
implements ITickableRequirement<EntityMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<EntityRequirement> CODEC = NamedCodec.record(entityRequirementInstance -> entityRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), ACTION.CODEC.fieldOf("action").forGetter(requirement -> requirement.action), NamedCodec.INT.fieldOf("amount").forGetter(requirement -> requirement.amount), NamedCodec.INT.fieldOf("radius").forGetter(requirement -> requirement.radius), RegistrarCodec.ENTITY.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(requirement -> requirement.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(requirement -> requirement.whitelist), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(AbstractDelayedRequirement::getDelay), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance)).apply((Applicative)entityRequirementInstance, (mode, action, amount, radius, filter, whitelist, delay, chance) -> {
        EntityRequirement requirement = new EntityRequirement((RequirementIOMode)((Object)((Object)mode)), (ACTION)((Object)((Object)action)), (int)amount, (int)radius, (List<class_1299<?>>)filter, (boolean)whitelist);
        requirement.setDelay((double)delay);
        requirement.setChance((double)chance);
        return requirement;
    }), "Entity requirement");
    private final ACTION action;
    private final int amount;
    private final int radius;
    private final List<class_1299<?>> filter;
    private final boolean whitelist;
    private final Predicate<class_1297> predicate;

    public EntityRequirement(RequirementIOMode mode, ACTION action, int amount, int radius, List<class_1299<?>> filter, boolean whitelist) {
        super(mode);
        this.action = action;
        this.amount = amount;
        this.radius = radius;
        this.filter = filter;
        this.whitelist = whitelist;
        this.predicate = entity -> filter.contains(entity.method_5864()) == whitelist;
    }

    @Override
    public RequirementType<EntityRequirement> getType() {
        return (RequirementType)((Object)Registration.ENTITY_REQUIREMENT.get());
    }

    @Override
    public boolean test(EntityMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
        if (this.action == ACTION.CHECK_AMOUNT || this.action == ACTION.KILL) {
            return component.getEntitiesInRadius(radius, this.predicate) >= amount;
        }
        return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount;
    }

    @Override
    public CraftingResult processStart(EntityMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
        if (this.getMode() == RequirementIOMode.INPUT) {
            switch (this.action) {
                case CHECK_AMOUNT: {
                    return component.getEntitiesInRadius(radius, this.predicate) >= amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
                case CHECK_HEALTH: {
                    return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case CONSUME_HEALTH: {
                    if (component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount) {
                        component.removeEntitiesHealth(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case KILL: {
                    if (component.getEntitiesInRadius(radius, this.predicate) >= amount) {
                        component.killEntities(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(EntityMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
        if (this.getMode() == RequirementIOMode.OUTPUT) {
            switch (this.action) {
                case CONSUME_HEALTH: {
                    if (component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount) {
                        component.removeEntitiesHealth(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
                }
                case KILL: {
                    if (component.getEntitiesInRadius(radius, this.predicate) >= amount) {
                        component.killEntities(radius, this.predicate, amount);
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<EntityMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.ENTITY_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(EntityMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
        if (this.action == ACTION.CHECK_AMOUNT) {
            return component.getEntitiesInRadius(radius, this.predicate) >= amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
        }
        if (this.action == ACTION.CHECK_HEALTH) {
            return component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount ? CraftingResult.success() : CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult execute(EntityMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        int radius = (int)context.getIntegerModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME_HEALTH: {
                if (component.getEntitiesInRadiusHealth(radius, this.predicate) >= (double)amount) {
                    component.removeEntitiesHealth(radius, this.predicate, amount);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.health.error", new Object[]{amount}));
            }
            case KILL: {
                if (component.getEntitiesInRadius(radius, this.predicate) >= amount) {
                    component.killEntities(radius, this.predicate, amount);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.entity.amount.error"));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity." + this.action.toString().toLowerCase(Locale.ENGLISH) + ".info", new Object[]{this.amount, this.radius}));
        if (!this.filter.isEmpty()) {
            if (this.whitelist) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity.whitelist"));
            } else {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.entity.blacklist"));
            }
        }
        this.filter.forEach(type -> info.addTooltip((class_2561)new class_2585("*").method_10852(type.method_5897())));
        info.setItemIcon(class_1802.field_8433);
    }

    public static enum ACTION {
        CHECK_AMOUNT,
        CHECK_HEALTH,
        CONSUME_HEALTH,
        KILL;

        public static final NamedCodec<ACTION> CODEC;

        public static ACTION value(String mode) {
            return ACTION.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }

        static {
            CODEC = NamedCodec.enumCodec(ACTION.class);
        }
    }
}

