/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.DropMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.RegistrarCodec;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public class DropRequirement
extends AbstractDelayedChanceableRequirement<DropMachineComponent>
implements ITickableRequirement<DropMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<DropRequirement> CODEC = NamedCodec.record(dropRequirementInstance -> dropRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(IRequirement::getMode), Action.CODEC.fieldOf("action").forGetter(requirement -> requirement.action), IIngredient.ITEM.listOf().optionalFieldOf("input", Collections.emptyList()).forGetter(requirement -> requirement.input), NamedCodec.BOOL.optionalFieldOf("whitelist", true).forGetter(requirement -> requirement.whitelist), RegistrarCodec.ITEM.optionalFieldOf("output", class_1802.field_8162).forGetter(requirement -> requirement.output), DefaultCodecs.COMPOUND_TAG.optionalFieldOf("nbt").forGetter(requirement -> Optional.ofNullable(requirement.nbt)), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("amount", 1).forGetter(requirement -> requirement.amount), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("radius", 1).forGetter(requirement -> requirement.radius), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(IDelayedRequirement::getDelay)).apply((Applicative)dropRequirementInstance, (mode, action, input, whitelist, output, nbt, amount, radius, chance, delay) -> {
        DropRequirement requirement = new DropRequirement((RequirementIOMode)((Object)((Object)mode)), (Action)((Object)((Object)action)), (List<IIngredient<class_1792>>)input, (boolean)whitelist, (class_1792)output, nbt.orElse(null), (int)amount, (int)radius);
        requirement.setChance((double)chance);
        requirement.setDelay((double)delay);
        return requirement;
    }), "Drop requirement");
    private final Action action;
    private final List<IIngredient<class_1792>> input;
    private final boolean whitelist;
    private final class_1792 output;
    @Nullable
    private final class_2487 nbt;
    private final int amount;
    private final int radius;

    public DropRequirement(RequirementIOMode mode, Action action, List<IIngredient<class_1792>> input, boolean whitelist, class_1792 output, @Nullable class_2487 nbt, int amount, int radius) {
        super(mode);
        this.action = action;
        if ((action == Action.CHECK || action == Action.CONSUME) && input.isEmpty()) {
            throw new IllegalArgumentException("Drop requirement in" + action + "  mode MUST have at least one input item ingredient !");
        }
        this.input = input;
        this.whitelist = whitelist;
        if (action == Action.PRODUCE && output == class_1802.field_8162) {
            throw new IllegalArgumentException("Drop requirement in " + action + " mode MUST have an output item specified !");
        }
        this.output = output;
        this.nbt = nbt;
        this.amount = amount;
        this.radius = radius;
    }

    @Override
    public RequirementType<DropRequirement> getType() {
        return (RequirementType)((Object)Registration.DROP_REQUIREMENT.get());
    }

    @Override
    public boolean test(DropMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.action == Action.CHECK || this.action == Action.CONSUME) {
            return component.getItemAmount(this.input, this.radius, this.whitelist) >= amount;
        }
        return true;
    }

    @Override
    public CraftingResult processStart(DropMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0 || this.getMode() != RequirementIOMode.INPUT) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        double radius = context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found >= amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{amount, found}));
            }
            case PRODUCE: {
                class_1799 stack = Utils.makeItemStack(this.output, amount, null);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{new class_2585(amount + "x").method_10852((class_2561)new class_2588(this.output.method_7866(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(DropMachineComponent component, ICraftingContext context) {
        if (this.getDelay() != 0.0 || this.getMode() != RequirementIOMode.OUTPUT) {
            return CraftingResult.pass();
        }
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        double radius = context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found > amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{amount, found}));
            }
            case PRODUCE: {
                class_1799 stack = Utils.makeItemStack(this.output, amount, null);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{new class_2585(amount + "x").method_10852((class_2561)new class_2588(this.output.method_7866(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<DropMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.DROP_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(DropMachineComponent component, ICraftingContext context) {
        if (this.action == Action.CHECK) {
            int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
            double radius = context.getModifiedValue(this.radius, this, "radius");
            int found = component.getItemAmount(this.input, radius, this.whitelist);
            if (found >= amount) {
                return CraftingResult.success();
            }
            return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{amount, found}));
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult execute(DropMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        double radius = context.getModifiedValue(this.radius, this, "radius");
        switch (this.action) {
            case CONSUME: {
                int found = component.getItemAmount(this.input, radius, this.whitelist);
                if (found > amount) {
                    component.consumeItem(this.input, amount, radius, this.whitelist);
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{amount, found}));
            }
            case PRODUCE: {
                class_1799 stack = Utils.makeItemStack(this.output, amount, null);
                if (component.produceItem(stack)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.drop.error.input", new Object[]{new class_2585(amount + "x").method_10852((class_2561)new class_2588(this.output.method_7866(stack)))}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        switch (this.action) {
            case CHECK: {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.drop.info.check", new Object[]{this.amount, this.radius}));
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.drop.info." + (this.whitelist ? "whitelist" : "blacklist")).method_27692(this.whitelist ? class_124.field_1077 : class_124.field_1079));
                this.input.forEach(ingredient -> info.addTooltip((class_2561)new class_2585(ingredient.toString())));
                info.setItemIcon(class_1802.field_8391);
                break;
            }
            case CONSUME: {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.drop.info.consume", new Object[]{this.amount, this.radius}));
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.drop.info." + (this.whitelist ? "whitelist" : "blacklist")).method_27692(this.whitelist ? class_124.field_1077 : class_124.field_1079));
                this.input.forEach(ingredient -> info.addTooltip((class_2561)new class_2585("- " + ingredient.toString())));
                info.setItemIcon(class_1802.field_8239);
                break;
            }
            case PRODUCE: {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.drop.info.produce", new Object[]{new class_2585(this.amount + "x ").method_10852((class_2561)new class_2588(this.output.method_7876())).method_27692(class_124.field_1065)}));
                info.setItemIcon(class_1802.field_8878);
            }
        }
    }

    public static enum Action {
        CHECK,
        CONSUME,
        PRODUCE;

        public static final NamedCodec<Action> CODEC;

        public static Action value(String mode) {
            return Action.valueOf(mode.toUpperCase(Locale.ENGLISH));
        }

        static {
            CODEC = NamedCodec.enumCodec(Action.class);
        }
    }
}

