/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.common.component.CommandMachineComponent;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedRequirement;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;

public class CommandRequirement
extends AbstractDelayedChanceableRequirement<CommandMachineComponent>
implements ITickableRequirement<CommandMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<CommandRequirement> CODEC = NamedCodec.record(commandRequirementInstance -> commandRequirementInstance.group(NamedCodec.STRING.fieldOf("command").forGetter(requirement -> requirement.command), MachineProcessor.PHASE.CODEC.fieldOf("phase").forGetter(requirement -> requirement.phase), NamedCodec.INT.optionalFieldOf("permissionlevel", 2).forGetter(requirement -> requirement.permissionLevel), NamedCodec.BOOL.optionalFieldOf("log", false).forGetter(requirement -> requirement.log), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(AbstractDelayedRequirement::getDelay)).apply((Applicative)commandRequirementInstance, (command, phase, permissionLevel, log, chance, delay) -> {
        CommandRequirement requirement = new CommandRequirement((String)command, (MachineProcessor.PHASE)((Object)((Object)phase)), (int)permissionLevel, (boolean)log);
        requirement.setChance((double)chance);
        requirement.setDelay((double)delay);
        return requirement;
    }), "Command requirement");
    private final String command;
    private final MachineProcessor.PHASE phase;
    private final int permissionLevel;
    private final boolean log;

    public CommandRequirement(String command, MachineProcessor.PHASE phase, int permissionLevel, boolean log) {
        super(RequirementIOMode.INPUT);
        this.command = command;
        this.phase = phase;
        this.permissionLevel = permissionLevel;
        this.log = log;
    }

    @Override
    public RequirementType<CommandRequirement> getType() {
        return (RequirementType)((Object)Registration.COMMAND_REQUIREMENT.get());
    }

    @Override
    public boolean test(CommandMachineComponent component, ICraftingContext context) {
        return true;
    }

    @Override
    public CraftingResult processStart(CommandMachineComponent component, ICraftingContext context) {
        if (this.phase == MachineProcessor.PHASE.STARTING && !this.isDelayed()) {
            component.sendCommand(this.command, this.permissionLevel, this.log);
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processTick(CommandMachineComponent component, ICraftingContext context) {
        if (this.phase == MachineProcessor.PHASE.CRAFTING_TICKABLE && !this.isDelayed()) {
            component.sendCommand(this.command, this.permissionLevel, this.log);
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(CommandMachineComponent component, ICraftingContext context) {
        if (this.phase == MachineProcessor.PHASE.ENDING && !this.isDelayed()) {
            component.sendCommand(this.command, this.permissionLevel, this.log);
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult execute(CommandMachineComponent component, ICraftingContext context) {
        component.sendCommand(this.command, this.permissionLevel, this.log);
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<CommandMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.COMMAND_MACHINE_COMPONENT.get());
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        info.setItemIcon(class_1802.field_8866);
        if (!this.isDelayed()) {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.command.info", new Object[]{new class_2585(this.command).method_27692(class_124.field_1075), this.phase.toString().toLowerCase(Locale.ENGLISH)}));
        } else {
            info.addTooltip((class_2561)new class_2588("custommachinery.requirements.command.delay", new Object[]{new class_2585(this.command).method_27692(class_124.field_1075), (int)(this.getDelay() * 100.0) + "%"}));
        }
    }
}

