/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.common.component.BlockMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Codecs;
import fr.frinn.custommachinery.common.util.ComparatorMode;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.requirement.AbstractDelayedChanceableRequirement;
import fr.frinn.custommachinery.impl.requirement.AbstractRequirement;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3532;

public class BlockRequirement
extends AbstractDelayedChanceableRequirement<BlockMachineComponent>
implements ITickableRequirement<BlockMachineComponent>,
IDisplayInfoRequirement {
    public static final NamedCodec<BlockRequirement> CODEC = NamedCodec.record(blockRequirementInstance -> blockRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(AbstractRequirement::getMode), ACTION.CODEC.fieldOf("action").forGetter(requirement -> requirement.action), Codecs.BOX_CODEC.fieldOf("pos").forGetter(requirement -> requirement.pos), NamedCodec.INT.optionalFieldOf("amount", 1).forGetter(requirement -> requirement.amount), ComparatorMode.CODEC.optionalFieldOf("comparator", ComparatorMode.GREATER_OR_EQUALS).forGetter(requirement -> requirement.comparator), PartialBlockState.CODEC.optionalFieldOf("block", PartialBlockState.AIR).forGetter(requirement -> requirement.block), IIngredient.BLOCK.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(requirement -> requirement.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(requirement -> requirement.whitelist), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("delay", 0.0).forGetter(requirement -> requirement.delay), NamedCodec.doubleRange(0.0, 1.0).optionalFieldOf("chance", 1.0).forGetter(AbstractDelayedChanceableRequirement::getChance)).apply((Applicative)blockRequirementInstance, (mode, action, pos, amount, comparator, block, filter, whitelist, delay, chance) -> {
        BlockRequirement requirement = new BlockRequirement((RequirementIOMode)((Object)((Object)mode)), (ACTION)((Object)((Object)action)), (class_238)pos, (int)amount, (ComparatorMode)((Object)((Object)comparator)), (PartialBlockState)block, (List<IIngredient<PartialBlockState>>)filter, (boolean)whitelist);
        requirement.setDelay((double)delay);
        requirement.setChance((double)chance);
        return requirement;
    }), "Block requirement");
    private final ACTION action;
    private final class_238 pos;
    private final int amount;
    private final ComparatorMode comparator;
    private final PartialBlockState block;
    private final List<IIngredient<PartialBlockState>> filter;
    private final boolean whitelist;
    private double delay;

    public BlockRequirement(RequirementIOMode mode, ACTION action, class_238 pos, int amount, ComparatorMode comparator, PartialBlockState block, List<IIngredient<PartialBlockState>> filter, boolean whitelist) {
        super(mode);
        this.action = action;
        this.pos = pos;
        this.amount = amount;
        this.comparator = comparator;
        this.block = block;
        this.filter = filter;
        this.whitelist = whitelist;
    }

    @Override
    public RequirementType<?> getType() {
        return (RequirementType)((Object)Registration.BLOCK_REQUIREMENT.get());
    }

    @Override
    public boolean test(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        return switch (this.action) {
            default -> throw new IncompatibleClassChangeError();
            case ACTION.CHECK -> this.comparator.compare((int)component.getBlockAmount(this.pos, this.filter, this.whitelist), amount);
            case ACTION.PLACE -> {
                if (this.delay != 0.0 || (int)component.getBlockAmount(this.pos, Collections.singletonList(BlockIngredient.AIR), true) >= amount) {
                    yield true;
                }
                yield false;
            }
            case ACTION.BREAK, ACTION.DESTROY, ACTION.REPLACE_BREAK, ACTION.REPLACE_DESTROY -> this.delay != 0.0 || (int)component.getBlockAmount(this.pos, this.filter, this.whitelist) >= amount;
        };
    }

    @Override
    public CraftingResult processStart(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.INPUT && this.delay == 0.0) {
            switch (this.action) {
                case PLACE: {
                    if (component.placeBlock(this.pos, this.block, amount)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case REPLACE_BREAK: {
                    if (component.replaceBlock(this.pos, this.block, amount, true, this.filter, this.whitelist)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case REPLACE_DESTROY: {
                    if (component.replaceBlock(this.pos, this.block, amount, false, this.filter, this.whitelist)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case BREAK: {
                    if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, true)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
                }
                case DESTROY: {
                    if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, false)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public CraftingResult processEnd(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.getMode() == RequirementIOMode.OUTPUT && this.delay == 0.0) {
            switch (this.action) {
                case PLACE: {
                    if (component.placeBlock(this.pos, this.block, amount)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case REPLACE_BREAK: {
                    if (component.replaceBlock(this.pos, this.block, amount, true, this.filter, this.whitelist)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case REPLACE_DESTROY: {
                    if (component.replaceBlock(this.pos, this.block, amount, false, this.filter, this.whitelist)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
                }
                case BREAK: {
                    if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, true)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
                }
                case DESTROY: {
                    if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, false)) {
                        return CraftingResult.success();
                    }
                    return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
                }
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public MachineComponentType<BlockMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.BLOCK_MACHINE_COMPONENT.get());
    }

    @Override
    public CraftingResult processTick(BlockMachineComponent component, ICraftingContext context) {
        if (this.action == ACTION.CHECK) {
            int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
            long found = component.getBlockAmount(this.pos, this.filter, this.whitelist);
            if (!this.comparator.compare((int)found, amount)) {
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.check.error", new Object[]{amount, this.pos.toString(), found}));
            }
            return CraftingResult.success();
        }
        return CraftingResult.pass();
    }

    @Override
    public void setDelay(double delay) {
        this.delay = class_3532.method_15350((double)delay, (double)0.0, (double)1.0);
    }

    @Override
    public double getDelay() {
        return this.delay;
    }

    @Override
    public CraftingResult execute(BlockMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        switch (this.action) {
            case PLACE: {
                if (component.placeBlock(this.pos, this.block, amount)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case REPLACE_BREAK: {
                if (component.replaceBlock(this.pos, this.block, amount, true, this.filter, this.whitelist)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case REPLACE_DESTROY: {
                if (component.replaceBlock(this.pos, this.block, amount, false, this.filter, this.whitelist)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.place.error", new Object[]{amount, this.block.getName(), this.pos.toString()}));
            }
            case BREAK: {
                if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, true)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
            }
            case DESTROY: {
                if (component.breakBlock(this.pos, this.filter, this.whitelist, amount, false)) {
                    return CraftingResult.success();
                }
                return CraftingResult.error((class_2561)new class_2588("custommachinery.requirements.block.break.error", new Object[]{amount, this.pos.toString()}));
            }
        }
        return CraftingResult.pass();
    }

    @Override
    public void getDisplayInfo(IDisplayInfo info) {
        class_2588 action = null;
        switch (this.action) {
            case CHECK: {
                action = new class_2588("custommachinery.requirements.block.check.info");
                break;
            }
            case BREAK: {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    action = new class_2588("custommachinery.requirements.block.break.info.input");
                    break;
                }
                action = new class_2588("custommachinery.requirements.block.break.info.output");
                break;
            }
            case DESTROY: {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    action = new class_2588("custommachinery.requirements.block.destroy.info.input");
                    break;
                }
                action = new class_2588("custommachinery.requirements.block.destroy.info.output");
                break;
            }
            case PLACE: {
                if (this.getMode() == RequirementIOMode.INPUT) {
                    action = new class_2588("custommachinery.requirements.block.place.info.input", new Object[]{this.amount, this.block.getName()});
                    break;
                }
                action = new class_2588("custommachinery.requirements.block.place.info.output", new Object[]{this.amount, this.block.getName()});
                break;
            }
            case REPLACE_BREAK: 
            case REPLACE_DESTROY: {
                action = this.getMode() == RequirementIOMode.INPUT ? new class_2588("custommachinery.requirements.block.replace.info.input", new Object[]{this.amount, this.block.getName()}) : new class_2588("custommachinery.requirements.block.replace.info.output", new Object[]{this.amount, this.block.getName()});
            }
        }
        if (action != null) {
            info.addTooltip((class_2561)action.method_27692(class_124.field_1075));
        }
        if (this.action != ACTION.PLACE) {
            if (this.action != ACTION.CHECK) {
                info.addTooltip((class_2561)new class_2588("custommachinery.requirements.block." + (this.whitelist ? "allowed" : "denied")).method_27692(this.whitelist ? class_124.field_1060 : class_124.field_1061));
            }
            if (this.whitelist && this.filter.isEmpty()) {
                info.addTooltip((class_2561)new class_2585("-").method_10852((class_2561)new class_2588("custommachinery.requirements.block.none")));
            } else if (!this.whitelist && this.filter.isEmpty()) {
                info.addTooltip((class_2561)new class_2585("-").method_10852((class_2561)new class_2588("custommachinery.requirements.block.all")));
            } else {
                this.filter.forEach(block -> info.addTooltip((class_2561)new class_2585("- " + block.toString())));
            }
        }
        info.addTooltip((class_2561)new class_2588("custommachinery.requirements.block.info.box").method_27692(class_124.field_1065));
        info.setClickAction((machine, mouseButton) -> CustomMachineRenderer.addRenderBox(machine.getId(), this.pos));
        info.setItemIcon(class_1802.field_8270);
    }

    public static enum ACTION {
        CHECK,
        BREAK,
        DESTROY,
        PLACE,
        REPLACE_BREAK,
        REPLACE_DESTROY;

        public static final NamedCodec<ACTION> CODEC;

        public static ACTION value(String value) {
            return ACTION.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        static {
            CODEC = NamedCodec.enumCodec(ACTION.class);
        }
    }
}

