/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network.syncable;

import fr.frinn.custommachinery.common.network.data.SideConfigData;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.network.AbstractSyncable;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class SideConfigSyncable
extends AbstractSyncable<SideConfigData, SideConfig> {
    @Override
    public SideConfigData getData(short id) {
        return new SideConfigData(id, (SideConfig)this.get());
    }

    @Override
    public boolean needSync() {
        SideConfig value = (SideConfig)this.get();
        if (this.lastKnownValue == null) {
            this.lastKnownValue = value.copy();
            return true;
        }
        for (RelativeSide side : RelativeSide.values()) {
            if (((SideConfig)this.lastKnownValue).getSideMode(side) == value.getSideMode(side)) continue;
            this.lastKnownValue = value.copy();
            return true;
        }
        if (((SideConfig)this.lastKnownValue).isAutoInput() != value.isAutoInput() || ((SideConfig)this.lastKnownValue).isAutoOutput() != value.isAutoOutput()) {
            this.lastKnownValue = value.copy();
            return true;
        }
        return false;
    }

    public static SideConfigSyncable create(final Supplier<SideConfig> supplier, final Consumer<SideConfig> consumer) {
        return new SideConfigSyncable(){

            @Override
            public SideConfig get() {
                return (SideConfig)supplier.get();
            }

            @Override
            public void set(SideConfig value) {
                consumer.accept(value);
            }
        };
    }
}

