/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.api.network.IData;
import fr.frinn.custommachinery.client.ClientPacketHandler;
import fr.frinn.custommachinery.common.network.PacketManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;

public class SUpdateContainerPacket
extends BaseS2CMessage {
    private final int windowId;
    private final List<IData<?>> data;

    public SUpdateContainerPacket(int windowId, List<IData<?>> data) {
        this.data = data;
        this.windowId = windowId;
    }

    public MessageType getType() {
        return PacketManager.UPDATE_CONSTAINER;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.windowId);
        buf.writeShort(this.data.size());
        this.data.forEach(data -> data.writeData(buf));
    }

    public static SUpdateContainerPacket decode(class_2540 buf) {
        int windowId = buf.readInt();
        ArrayList dataList = new ArrayList();
        short size = buf.readShort();
        for (short i = 0; i < size; i = (short)(i + 1)) {
            IData<?> data = IData.readData(buf);
            if (data == null) continue;
            dataList.add(data);
        }
        return new SUpdateContainerPacket(windowId, dataList);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.CLIENT) {
            context.queue(() -> ClientPacketHandler.handleUpdateContainerPacket(this.windowId, this.data));
        }
    }
}

