/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import com.mojang.datafixers.util.Pair;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseS2CMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SLootTablesPacket
extends BaseS2CMessage {
    private final Map<class_2960, List<Pair<class_1799, Double>>> loots;

    public SLootTablesPacket(Map<class_2960, List<Pair<class_1799, Double>>> loots) {
        this.loots = loots;
    }

    public MessageType getType() {
        return PacketManager.LOOT_TABLES;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.loots.size());
        this.loots.forEach((id, loots) -> {
            buf.method_10812(id);
            buf.method_10804(loots.size());
            loots.forEach(pair -> {
                buf.method_10793((class_1799)pair.getFirst());
                buf.writeDouble(((Double)pair.getSecond()).doubleValue());
            });
        });
    }

    public static SLootTablesPacket decode(class_2540 buf) {
        HashMap<class_2960, List<Pair<class_1799, Double>>> loots = new HashMap<class_2960, List<Pair<class_1799, Double>>>();
        int lootSize = buf.method_10816();
        for (int i = 0; i < lootSize; ++i) {
            class_2960 id = buf.method_10810();
            ArrayList<Pair> stacks = new ArrayList<Pair>();
            int stackSize = buf.method_10816();
            for (int j = 0; j < stackSize; ++j) {
                stacks.add(Pair.of((Object)buf.method_10819(), (Object)buf.readDouble()));
            }
            loots.put(id, stacks);
        }
        return new SLootTablesPacket(loots);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.CLIENT) {
            context.queue(() -> LootTableHelper.receiveLoots(this.loots));
        }
    }
}

