/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.architectury.utils.Env;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.network.PacketManager;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;

public class CChangeSideModePacket
extends BaseC2SMessage {
    private final int containerID;
    private final String id;
    private final byte side;
    private final boolean next;

    public CChangeSideModePacket(int containerID, String id, byte side, boolean next) {
        this.containerID = containerID;
        this.id = id;
        this.side = side;
        this.next = next;
    }

    public MessageType getType() {
        return PacketManager.CHANGE_SIDE_MODE;
    }

    public void write(class_2540 buf) {
        buf.method_10804(this.containerID);
        buf.method_10814(this.id);
        buf.writeByte((int)this.side);
        buf.writeBoolean(this.next);
    }

    public static CChangeSideModePacket decode(class_2540 buf) {
        return new CChangeSideModePacket(buf.method_10816(), buf.method_19772(), buf.readByte(), buf.readBoolean());
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getEnvironment() == Env.SERVER) {
            context.queue(() -> {
                CustomMachineContainer container;
                Optional<ISideConfigComponent> component;
                class_1703 patt2017$temp;
                class_1657 player = context.getPlayer();
                if (player != null && player.field_7512.field_7763 == this.containerID && (patt2017$temp = player.field_7512) instanceof CustomMachineContainer && (component = (container = (CustomMachineContainer)patt2017$temp).getTile().getComponentManager().getConfigComponentById(this.id)).isPresent()) {
                    SideConfig config = component.get().getConfig();
                    switch (this.side) {
                        case 6: {
                            config.setAutoInput(!config.isAutoInput());
                            break;
                        }
                        case 7: {
                            config.setAutoOutput(!config.isAutoOutput());
                            break;
                        }
                        default: {
                            RelativeSide side = RelativeSide.values()[this.side];
                            if (this.next) {
                                config.setSideMode(side, config.getSideMode(side).next());
                                break;
                            }
                            config.setSideMode(side, config.getSideMode(side).previous());
                        }
                    }
                }
            });
        }
    }
}

