/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.io.File;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class MachineLocation {
    public static final NamedCodec<MachineLocation> CODEC = NamedCodec.record(machineLocationInstance -> machineLocationInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("id").forGetter(MachineLocation::getId), Loader.CODEC.fieldOf("loader").forGetter(MachineLocation::getLoader), NamedCodec.STRING.fieldOf("packName").forGetter(MachineLocation::getPackName)).apply((Applicative)machineLocationInstance, MachineLocation::new), "Machine location");
    private final class_2960 id;
    private final Loader loader;
    private final String packName;

    private MachineLocation(class_2960 id, Loader loader, String packName) {
        this.id = id;
        this.loader = loader;
        this.packName = packName;
    }

    public static MachineLocation fromLoader(Loader loader, class_2960 id, String packName) {
        return switch (loader) {
            default -> throw new IncompatibleClassChangeError();
            case Loader.DEFAULT -> MachineLocation.fromDefault(id);
            case Loader.DATAPACK -> MachineLocation.fromDatapack(id, packName);
            case Loader.CRAFTTWEAKER -> MachineLocation.fromCraftTweaker(id);
            case Loader.KUBEJS -> MachineLocation.fromKubeJS(id);
        };
    }

    public static MachineLocation fromDefault(class_2960 id) {
        return new MachineLocation(id, Loader.DEFAULT, "");
    }

    public static MachineLocation fromDatapack(class_2960 id, String packName) {
        return new MachineLocation(id, Loader.DATAPACK, packName);
    }

    public static MachineLocation fromCraftTweaker(class_2960 id) {
        return new MachineLocation(id, Loader.CRAFTTWEAKER, "");
    }

    public static MachineLocation fromKubeJS(class_2960 id) {
        return new MachineLocation(id, Loader.KUBEJS, "");
    }

    public class_2960 getId() {
        return this.id;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getPath() {
        return this.packName + File.separator + "data" + File.separator + this.id.method_12836() + File.separator + "machines" + File.separator + this.id.method_12832() + ".json";
    }

    public static enum Loader {
        DEFAULT,
        DATAPACK,
        CRAFTTWEAKER,
        KUBEJS;

        public static final NamedCodec<Loader> CODEC;

        public class_2588 getTranslatedName() {
            return new class_2588("custommachinery.machine.loader." + this.name().toLowerCase(Locale.ENGLISH));
        }

        public int getColor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> class_124.field_1074.method_532();
                case DATAPACK -> class_124.field_1077.method_532();
                case KUBEJS -> class_124.field_1064.method_532();
                case CRAFTTWEAKER -> class_124.field_1062.method_532();
            };
        }

        public static Loader value(String value) {
            return Loader.valueOf(value.toUpperCase(Locale.ENGLISH));
        }

        public String toString() {
            return super.toString().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = NamedCodec.enumCodec(Loader.class);
        }
    }
}

