/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import java.io.IOException;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;

public class CustomMachineJsonReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";

    public CustomMachineJsonReloadListener() {
        super("machines");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        ICustomMachineryAPI.INSTANCE.logger().info("Reading Custom Machinery Machines...");
        CustomMachinery.MACHINES.clear();
        map.forEach((id, json) -> {
            String packName;
            try {
                packName = resourceManager.method_14486(new class_2960(id.method_12836(), "machines/" + id.method_12832() + ".json")).method_14480();
            }
            catch (IOException e) {
                packName = MAIN_PACKNAME;
            }
            ICustomMachineryAPI.INSTANCE.logger().info("Parsing machine json: {} in datapack: {}", id, (Object)packName);
            if (!json.isJsonObject()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Bad machine JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            if (CustomMachinery.MACHINES.containsKey(id)) {
                ICustomMachineryAPI.INSTANCE.logger().error("A machine with id: {} already exists, skipping...", id);
                return;
            }
            DataResult<CustomMachine> result = CustomMachine.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                CustomMachine machine = (CustomMachine)result.result().get();
                if (packName.equals(MAIN_PACKNAME)) {
                    machine.setLocation(MachineLocation.fromDefault(id));
                } else {
                    machine.setLocation(MachineLocation.fromDatapack(id, packName));
                }
                CustomMachinery.MACHINES.put((class_2960)id, machine);
                ICustomMachineryAPI.INSTANCE.logger().info("Successfully parsed machine json: {}", id);
                return;
            }
            if (result.error().isPresent()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing machine json: {}, skipping...\n{}", id, (Object)((DataResult.PartialResult)result.error().get()).message());
                return;
            }
            throw new IllegalStateException("No success nor error when parsing machine json: " + id + ". This can't happen.");
        });
        ICustomMachineryAPI.INSTANCE.logger().info("Finished creating custom machines.");
    }
}

