/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.util.MapJS;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.FluidRequirement;
import fr.frinn.custommachinery.common.util.ingredient.FluidIngredient;
import fr.frinn.custommachinery.common.util.ingredient.FluidTagIngredient;

public interface FluidRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requireFluid(FluidStackJS stack) {
        return this.requireFluid(stack, "");
    }

    default public RecipeJSBuilder requireFluid(FluidStackJS stack, String tank) {
        return this.addRequirement(new FluidRequirement(RequirementIOMode.INPUT, new FluidIngredient(stack.getFluid()), (int)stack.getAmount(), stack.getFluidStack().getTag(), tank));
    }

    default public RecipeJSBuilder requireFluidTag(String tag, int amount) {
        return this.requireFluidTag(tag, amount, null, "");
    }

    default public RecipeJSBuilder requireFluidTag(String tag, int amount, Object thing) {
        if (thing instanceof String) {
            return this.requireFluidTag(tag, amount, null, (String)thing);
        }
        return this.requireFluidTag(tag, amount, MapJS.of((Object)thing), "");
    }

    default public RecipeJSBuilder requireFluidTag(String tag, int amount, MapJS nbt, String tank) {
        try {
            return this.addRequirement(new FluidRequirement(RequirementIOMode.INPUT, FluidTagIngredient.create(tag), amount, nbt == null ? null : nbt.toNBT(), tank));
        }
        catch (IllegalArgumentException e) {
            return this.error(e.getMessage(), new Object[0]);
        }
    }

    default public RecipeJSBuilder produceFluid(FluidStackJS stack) {
        return this.produceFluid(stack, "");
    }

    default public RecipeJSBuilder produceFluid(FluidStackJS stack, String tank) {
        return this.addRequirement(new FluidRequirement(RequirementIOMode.OUTPUT, new FluidIngredient(stack.getFluid()), (int)stack.getAmount(), stack.getFluidStack().getTag(), tank));
    }
}

