/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import dev.latvian.mods.kubejs.item.ItemStackJS;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.requirement.DropRequirement;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;

public interface DropRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder checkDrop(ItemStackJS item, int amount, int radius) {
        return this.checkDrops(new ItemStackJS[]{item}, amount, radius, true);
    }

    default public RecipeJSBuilder checkAnyDrop(int amount, int radius) {
        return this.checkDrops(new ItemStackJS[0], amount, radius, false);
    }

    default public RecipeJSBuilder checkDrops(ItemStackJS[] items, int amount, int radius) {
        return this.checkDrops(items, amount, radius, true);
    }

    default public RecipeJSBuilder checkDrops(ItemStackJS[] items, int amount, int radius, boolean whitelist) {
        if (items.length == 0) {
            return this.error("Invalid Drop requirement, checkDrop method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(ItemStackJS::getItem).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CHECK, input, whitelist, class_1802.field_8162, KubeJSIntegration.nbtFromStack(items[0]), amount, radius));
    }

    default public RecipeJSBuilder consumeDropOnStart(ItemStackJS item, int amount, int radius) {
        return this.consumeDropsOnStart(new ItemStackJS[]{item}, amount, radius, true);
    }

    default public RecipeJSBuilder consumeAnyDropOnStart(int amount, int radius) {
        return this.consumeDropsOnStart(new ItemStackJS[0], amount, radius, false);
    }

    default public RecipeJSBuilder consumeDropsOnStart(ItemStackJS[] items, int amount, int radius) {
        return this.consumeDropsOnStart(items, amount, radius, true);
    }

    default public RecipeJSBuilder consumeDropsOnStart(ItemStackJS[] items, int amount, int radius, boolean whitelist) {
        if (items.length == 0) {
            return this.error("Invalid Drop requirement, consumeDropOnStart method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(ItemStackJS::getItem).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CONSUME, input, whitelist, class_1802.field_8162, KubeJSIntegration.nbtFromStack(items[0]), amount, radius));
    }

    default public RecipeJSBuilder consumeDropOnEnd(ItemStackJS item, int amount, int radius) {
        return this.consumeDropsOnEnd(new ItemStackJS[]{item}, amount, radius, true);
    }

    default public RecipeJSBuilder consumeAnyDropOnEnd(int amount, int radius) {
        return this.consumeDropsOnEnd(new ItemStackJS[0], amount, radius, false);
    }

    default public RecipeJSBuilder consumeDropsOnEnd(ItemStackJS[] items, int amount, int radius) {
        return this.consumeDropsOnEnd(items, amount, radius, true);
    }

    default public RecipeJSBuilder consumeDropsOnEnd(ItemStackJS[] items, int amount, int radius, boolean whitelist) {
        if (items.length == 0) {
            return this.error("Invalid Drop requirement, consumeDropOnEnd method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(ItemStackJS::getItem).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.CONSUME, input, whitelist, class_1802.field_8162, KubeJSIntegration.nbtFromStack(items[0]), amount, radius));
    }

    default public RecipeJSBuilder dropItemOnStart(ItemStackJS stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.PRODUCE, Collections.emptyList(), true, stack.getItem(), KubeJSIntegration.nbtFromStack(stack), stack.getCount(), 1));
    }

    default public RecipeJSBuilder dropItemOnEnd(ItemStackJS stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.PRODUCE, Collections.emptyList(), true, stack.getItem(), KubeJSIntegration.nbtFromStack(stack), stack.getCount(), 1));
    }
}

