/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.function;

import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.Wrapper;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.component.DataMachineComponent;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class MachineJS {
    private final CustomMachineTile internal;
    private final class_2487 nbt;

    protected MachineJS(CustomMachineTile internal) {
        this.internal = internal;
        this.nbt = ((DataMachineComponent)this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.DATA_MACHINE_COMPONENT.get())).orElseThrow()).getData();
    }

    public static MachineJS of(Object o) {
        class_2586 blockEntity;
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof class_2586 && (blockEntity = (class_2586)o) instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)blockEntity;
            return new MachineJS(customMachineTile);
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS blockContainerJS = (BlockContainerJS)o;
            return MachineJS.of(blockContainerJS.getEntity());
        }
        return null;
    }

    public String getId() {
        return this.internal.getId().toString();
    }

    @Nullable
    public class_2487 getData() {
        return this.nbt;
    }

    public long getEnergyStored() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(EnergyMachineComponent::getEnergy).orElse(0L);
    }

    public void setEnergyStored(long energy) {
        this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).ifPresent(component -> component.setEnergy(energy));
    }

    public long getEnergyCapacity() {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(EnergyMachineComponent::getCapacity).orElse(0L);
    }

    public int addEnergy(int toAdd, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(component -> component.receiveRecipeEnergy(toAdd, simulate)).orElse(0);
    }

    public int removeEnergy(int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponent((MachineComponentType)((Object)Registration.ENERGY_MACHINE_COMPONENT.get())).map(component -> component.extractRecipeEnergy(toRemove, simulate)).orElse(0);
    }

    public FluidStackJS getFluidStored(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(component -> {
            FluidStack stack = component.getFluidStack();
            return FluidStackJS.of((Object)stack.getFluid(), (long)stack.getAmount(), (class_2487)stack.getTag());
        }).orElse((FluidStackJS)EmptyFluidStackJS.INSTANCE);
    }

    public void setFluidStored(String tank, FluidStackJS stackJS) {
        FluidStack stack = stackJS.getFluidStack();
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(x -> x.setFluidStack(stack));
    }

    public long getFluidCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getCapacity).orElse(0L);
    }

    public long addFluid(FluidStackJS stackJS, boolean simulate) {
        FluidStack stack = stackJS.getFluidStack();
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.fill(stack, simulate)).orElse(stack.getAmount());
    }

    public long addFluidToTank(String tank, FluidStackJS stackJS, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.insert(stackJS.getFluid(), (int)stackJS.getAmount(), stackJS.getNbt(), simulate)).orElse(stackJS.getAmount());
    }

    public FluidStackJS removeFluid(FluidStackJS stackJS, boolean simulate) {
        FluidStack stack = stackJS.getFluidStack();
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(handler -> (FluidComponentHandler)handler).map(handler -> {
            FluidStack removed = handler.drain(stack, simulate);
            return FluidStackJS.of((Object)removed);
        }).orElse((FluidStackJS)EmptyFluidStackJS.INSTANCE);
    }

    public FluidStackJS removeFluidFromTank(String tank, long amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).map(component -> {
            FluidStack stack = component.extract(amount, simulate);
            return FluidStackJS.of((Object)stack.getFluid(), (long)stack.getAmount(), (class_2487)stack.getTag());
        }).orElse((FluidStackJS)EmptyFluidStackJS.INSTANCE);
    }

    public ItemStackJS getItemStored(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> ItemStackJS.of((Object)component.getItemStack())).orElse(ItemStackJS.EMPTY);
    }

    public void setItemStored(String slot, ItemStackJS stackJS) {
        this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setItemStack(stackJS.getItemStack()));
    }

    public int getItemCapacity(String slot) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getCapacity).orElse(0);
    }

    public ItemStackJS addItemToSlot(String slot, ItemStackJS stackJS, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> {
            class_1799 stack = stackJS.getItemStack();
            int inserted = component.insert(stack.method_7909(), stack.method_7947(), stack.method_7969(), simulate, true);
            return ItemStackJS.of((Object)Utils.makeItemStack(stack.method_7909(), stack.method_7947() - inserted, stack.method_7969()));
        }).orElse(stackJS);
    }

    public ItemStackJS removeItemFromSlot(String slot, int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(slot)).map(component -> ItemStackJS.of((Object)component.extract(toRemove, simulate, true))).orElse(ItemStackJS.EMPTY);
    }
}

