/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker.requirements;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import fr.frinn.custommachinery.api.integration.crafttweaker.RecipeCTBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.integration.crafttweaker.CTUtils;
import fr.frinn.custommachinery.common.requirement.DropRequirement;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.common.util.ingredient.ItemIngredient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.requirement.Drop")
public interface DropRequirementCT<T>
extends RecipeCTBuilder<T> {
    @ZenCodeType.Method
    default public T checkDrop(IItemStack item, int radius) {
        return this.checkDrops(new IItemStack[]{item}, item.getAmount(), radius, true);
    }

    @ZenCodeType.Method
    default public T checkAnyDrop(int amount, int radius) {
        return this.checkDrops(new IItemStack[0], amount, radius, false);
    }

    @ZenCodeType.Method
    default public T checkDrops(IItemStack[] items, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        if (items.length == 0 && whitelist) {
            return this.error("Invalid Drop requirement, checkDrop method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(IItemStack::getDefinition).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CHECK, input, whitelist, class_1802.field_8162, CTUtils.nbtFromStack(items[0]), amount, radius));
    }

    @ZenCodeType.Method
    default public T consumeDropOnStart(IItemStack item, int radius) {
        return this.consumeDropsOnStart(new IItemStack[]{item}, item.getAmount(), radius, true);
    }

    @ZenCodeType.Method
    default public T consumeAnyDropOnStart(int amount, int radius) {
        return this.consumeDropsOnStart(new IItemStack[0], amount, radius, false);
    }

    @ZenCodeType.Method
    default public T consumeDropsOnStart(IItemStack[] items, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        if (items.length == 0 && whitelist) {
            return this.error("Invalid Drop requirement, consumeDropOnStart method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(IItemStack::getDefinition).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.CONSUME, input, whitelist, class_1802.field_8162, CTUtils.nbtFromStack(items[0]), amount, radius));
    }

    @ZenCodeType.Method
    default public T consumeDropOnEnd(IItemStack item, int radius) {
        return this.consumeDropsOnEnd(new IItemStack[]{item}, item.getAmount(), radius, true);
    }

    @ZenCodeType.Method
    default public T consumeAnyDropOnEnd(int amount, int radius) {
        return this.consumeDropsOnEnd(new IItemStack[0], amount, radius, false);
    }

    @ZenCodeType.Method
    default public T consumeDropsOnEnd(IItemStack[] items, int amount, int radius, @ZenCodeType.OptionalBoolean(value=true) boolean whitelist) {
        if (items.length == 0 && whitelist) {
            return this.error("Invalid Drop requirement, consumeDropOnEnd method must have at least 1 item defined when using whitelist mode", new Object[0]);
        }
        List<IIngredient<class_1792>> input = Arrays.stream(items).map(IItemStack::getDefinition).map(ItemIngredient::new).collect(Collectors.toList());
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.CONSUME, input, whitelist, class_1802.field_8162, CTUtils.nbtFromStack(items[0]), amount, radius));
    }

    @ZenCodeType.Method
    default public T dropItemOnStart(IItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.INPUT, DropRequirement.Action.PRODUCE, Collections.emptyList(), true, stack.getDefinition(), CTUtils.nbtFromStack(stack), stack.getAmount(), 1));
    }

    @ZenCodeType.Method
    default public T dropItemOnEnd(IItemStack stack) {
        return this.addRequirement(new DropRequirement(RequirementIOMode.OUTPUT, DropRequirement.Action.PRODUCE, Collections.emptyList(), true, stack.getDefinition(), CTUtils.nbtFromStack(stack), stack.getAmount(), 1));
    }
}

