/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.data.base.visitor.DataToJsonStringVisitor;
import com.blamejared.crafttweaker.api.data.base.visitor.DataVisitor;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipeBuilder;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomCraftRecipeCTBuilder;
import java.util.List;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CraftRecipeManager")
public class CustomCraftRecipeCTManager
implements IRecipeManager<CustomCraftRecipe> {
    public static final CustomCraftRecipeCTManager INSTANCE = new CustomCraftRecipeCTManager();

    public class_3956<CustomCraftRecipe> getRecipeType() {
        return (class_3956)Registration.CUSTOM_CRAFT_RECIPE.get();
    }

    public class_2960 getBracketResourceLocation() {
        return Registration.CUSTOM_CRAFT_RECIPE.getId();
    }

    public void addJsonRecipe(String name, MapData mapData) {
        JsonObject recipeObject = (JsonObject)JSON_RECIPE_GSON.fromJson((String)mapData.accept((DataVisitor)DataToJsonStringVisitor.INSTANCE), JsonObject.class);
        DataResult<CustomCraftRecipeBuilder> result = CustomCraftRecipeBuilder.CODEC.read(JsonOps.INSTANCE, recipeObject);
        if (result.error().isPresent() || result.result().isEmpty()) {
            CraftTweakerAPI.LOGGER.error("Couldn't add custom craft recipe {} from json: {}", (Object)name, (Object)((DataResult.PartialResult)result.error().get()).message());
            return;
        }
        class_2960 id = class_2960.method_12829((String)name);
        if (id == null) {
            CraftTweakerAPI.LOGGER.error("Invalid id for custom craft recipe: {}", (Object)name);
            return;
        }
        CustomCraftRecipe recipe = ((CustomCraftRecipeBuilder)result.result().get()).build(id);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (class_1860)recipe));
    }

    public List<CustomCraftRecipe> getRecipesByOutput(IIngredient output) {
        throw new UnsupportedOperationException("Can't get custom craft recipe by output");
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("Can't remove custom craft recipe by output");
    }

    public void removeByInput(IItemStack input) {
        throw new UnsupportedOperationException("Can't remove custom craft recipe by input");
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder create(String machine, IItemStack output) {
        return CustomCraftRecipeCTBuilder.create(machine, output);
    }
}

