/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import fr.frinn.custommachinery.api.requirement.IChanceableRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipeBuilder;
import fr.frinn.custommachinery.common.integration.crafttweaker.CustomCraftRecipeCTManager;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.BiomeRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.BlockRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.ButtonRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.CommandRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DimensionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DropRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.DurabilityRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EffectRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EnergyPerTickRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EnergyRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.EntityRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FluidPerTickRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FluidRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FuelRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.FunctionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.ItemRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.ItemTransformRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.LightRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.LootTableRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.PositionRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.RedstoneRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.SkyRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.StructureRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.TimeRequirementCT;
import fr.frinn.custommachinery.common.integration.crafttweaker.requirements.WeatherRequirementCT;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_151;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CraftRecipeBuilder")
public class CustomCraftRecipeCTBuilder
implements EnergyRequirementCT<CustomCraftRecipeCTBuilder>,
EnergyPerTickRequirementCT<CustomCraftRecipeCTBuilder>,
FluidRequirementCT<CustomCraftRecipeCTBuilder>,
FluidPerTickRequirementCT<CustomCraftRecipeCTBuilder>,
ItemRequirementCT<CustomCraftRecipeCTBuilder>,
ItemTransformRequirementCT<CustomCraftRecipeCTBuilder>,
DurabilityRequirementCT<CustomCraftRecipeCTBuilder>,
TimeRequirementCT<CustomCraftRecipeCTBuilder>,
PositionRequirementCT<CustomCraftRecipeCTBuilder>,
BiomeRequirementCT<CustomCraftRecipeCTBuilder>,
DimensionRequirementCT<CustomCraftRecipeCTBuilder>,
FuelRequirementCT<CustomCraftRecipeCTBuilder>,
CommandRequirementCT<CustomCraftRecipeCTBuilder>,
EffectRequirementCT<CustomCraftRecipeCTBuilder>,
WeatherRequirementCT<CustomCraftRecipeCTBuilder>,
RedstoneRequirementCT<CustomCraftRecipeCTBuilder>,
EntityRequirementCT<CustomCraftRecipeCTBuilder>,
LightRequirementCT<CustomCraftRecipeCTBuilder>,
BlockRequirementCT<CustomCraftRecipeCTBuilder>,
StructureRequirementCT<CustomCraftRecipeCTBuilder>,
LootTableRequirementCT<CustomCraftRecipeCTBuilder>,
DropRequirementCT<CustomCraftRecipeCTBuilder>,
FunctionRequirementCT<CustomCraftRecipeCTBuilder>,
ButtonRequirementCT<CustomCraftRecipeCTBuilder>,
SkyRequirementCT<CustomCraftRecipeCTBuilder> {
    public static final Map<class_2960, Integer> IDS = new HashMap<class_2960, Integer>();
    private final CustomCraftRecipeBuilder builder;
    private IRequirement<?> lastRequirement;
    private boolean jei = false;

    public CustomCraftRecipeCTBuilder(CustomCraftRecipeBuilder builder) {
        this.builder = builder;
    }

    @ZenCodeType.Method
    public static CustomCraftRecipeCTBuilder create(String machine, IItemStack output) {
        try {
            return new CustomCraftRecipeCTBuilder(new CustomCraftRecipeBuilder(new class_2960(machine), output.getImmutableInternal()));
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Invalid Machine name: " + machine + "\n" + e.getMessage());
        }
    }

    @ZenCodeType.Method
    public void build(@ZenCodeType.OptionalString String name) {
        class_2960 recipeID;
        try {
            if (!name.isEmpty()) {
                recipeID = name.contains(":") ? new class_2960(name) : new class_2960("crafttweaker", name);
            } else {
                int uniqueID = IDS.computeIfAbsent(this.builder.getMachine(), m -> 0);
                IDS.put(this.builder.getMachine(), uniqueID + 1);
                recipeID = new class_2960("crafttweaker", "custom_craft/" + this.builder.getMachine().method_12836() + "/" + this.builder.getMachine().method_12832() + "/" + uniqueID);
            }
        }
        catch (class_151 e) {
            throw new IllegalArgumentException("Invalid Recipe name: " + name + "\n" + e.getMessage());
        }
        CustomCraftRecipe recipe = this.builder.build(recipeID);
        ActionAddRecipe action = new ActionAddRecipe((IRecipeManager)CustomCraftRecipeCTManager.INSTANCE, (class_1860)recipe);
        CraftTweakerAPI.apply((IAction)action);
    }

    @Override
    public CustomCraftRecipeCTBuilder addRequirement(IRequirement<?> requirement) {
        this.lastRequirement = requirement;
        if (!this.jei) {
            this.builder.withRequirement((IRequirement)requirement);
        } else {
            this.builder.withJeiRequirement((IRequirement)requirement);
        }
        return this;
    }

    @Override
    public CustomCraftRecipeCTBuilder error(String error, Object ... args) {
        CraftTweakerAPI.LOGGER.error(error, args);
        return this;
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder chance(double chance) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IChanceableRequirement) {
            ((IChanceableRequirement)this.lastRequirement).setChance(chance);
        } else {
            CraftTweakerAPI.LOGGER.error("Can't set chance for requirement: " + this.lastRequirement);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder hide() {
        this.builder.hide();
        return this;
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder delay(double delay) {
        if (this.lastRequirement != null && this.lastRequirement instanceof IDelayedRequirement) {
            ((IDelayedRequirement)this.lastRequirement).setDelay(delay);
        } else {
            CraftTweakerAPI.LOGGER.error("Can't put delay for requirement: " + this.lastRequirement);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder jei() {
        this.jei = true;
        return this;
    }

    @ZenCodeType.Method
    public CustomCraftRecipeCTBuilder priority(int priority) {
        if (!this.jei) {
            this.builder.withPriority(priority);
        } else {
            this.builder.withJeiPriority(priority);
        }
        return this;
    }
}

