/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class CustomMachineItem
extends class_1747 {
    public static final String MACHINE_TAG_KEY = "machine";
    @Nullable
    private final class_2960 machineID;

    public CustomMachineItem(class_2248 block, class_1792.class_1793 properties, @Nullable class_2960 machineID) {
        super(block, properties);
        this.machineID = machineID;
    }

    public static Optional<CustomMachine> getMachine(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CustomMachineItem) {
            CustomMachineItem customMachineItem = (CustomMachineItem)class_17922;
            if (customMachineItem.machineID != null) {
                return Optional.ofNullable(CustomMachinery.MACHINES.get(customMachineItem.machineID));
            }
        }
        if (stack.method_7909() == Registration.CUSTOM_MACHINE_ITEM.get() && stack.method_7969() != null && stack.method_7969().method_10573(MACHINE_TAG_KEY, 8) && Utils.isResourceNameValid(stack.method_7969().method_10558(MACHINE_TAG_KEY))) {
            class_2960 machineID = new class_2960(stack.method_7969().method_10558(MACHINE_TAG_KEY));
            if (machineID.equals((Object)CustomMachine.DUMMY.getId())) {
                return Optional.of(CustomMachine.DUMMY);
            }
            return Optional.ofNullable(CustomMachinery.MACHINES.get(machineID));
        }
        return Optional.empty();
    }

    public static class_1799 makeMachineItem(class_2960 machineID) {
        if (CustomMachinery.CUSTOM_BLOCK_MACHINES.containsKey(machineID)) {
            return CustomMachinery.CUSTOM_BLOCK_MACHINES.get(machineID).method_8389().method_7854();
        }
        class_1799 stack = ((CustomMachineItem)((Object)Registration.CUSTOM_MACHINE_ITEM.get())).method_7854();
        class_2487 nbt = new class_2487();
        nbt.method_10582(MACHINE_TAG_KEY, machineID.toString());
        stack.method_7980(nbt);
        return stack;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> items) {
        if (this.method_7877(group)) {
            if (this.machineID != null) {
                items.add((Object)this.method_7854());
            } else {
                CustomMachinery.MACHINES.keySet().stream().filter(id -> !CustomMachinery.CUSTOM_BLOCK_MACHINES.containsKey(id)).forEach(id -> items.add((Object)CustomMachineItem.makeMachineItem(id)));
            }
        }
    }

    public void method_7843(class_1799 stack, class_1937 worldIn, class_1657 playerIn) {
        if (stack.method_7969() == null || !stack.method_7969().method_10573(MACHINE_TAG_KEY, 8)) {
            class_2487 nbt = new class_2487();
            nbt.method_10582(MACHINE_TAG_KEY, CustomMachine.DUMMY.getId().toString());
            stack.method_7980(nbt);
        }
        super.method_7843(stack, worldIn, playerIn);
    }

    public class_2561 method_7864(class_1799 stack) {
        return CustomMachineItem.getMachine(stack).map(CustomMachine::getName).orElse(super.method_7864(stack));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        CustomMachineItem.getMachine(stack).map(CustomMachine::getTooltips).ifPresent(tooltip::addAll);
    }

    public class_1269 method_7712(class_1750 blockPlaceContext) {
        class_2248 class_22482;
        if (!blockPlaceContext.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 blockPlaceContext2 = this.method_16356(blockPlaceContext);
        if (blockPlaceContext2 == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = this.method_7707(blockPlaceContext2);
        if (blockState == null) {
            return class_1269.field_5814;
        }
        if (!this.method_7708(blockPlaceContext2, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = blockPlaceContext2.method_8037();
        class_1937 level = blockPlaceContext2.method_8045();
        class_1657 player = blockPlaceContext2.method_8036();
        class_1799 itemStack = blockPlaceContext2.method_8041();
        class_2680 blockState2 = level.method_8320(blockPos);
        if (blockState2.method_27852(blockState.method_26204())) {
            this.method_7710(blockPos, level, player, itemStack, blockState2);
            blockState2.method_26204().method_9567(level, blockPos, blockState2, (class_1309)player, itemStack);
            if (player instanceof class_3222) {
                class_174.field_1191.method_9087((class_3222)player, blockPos, itemStack);
            }
        }
        if ((class_22482 = blockState2.method_26204()) instanceof CustomMachineBlock) {
            CustomMachineBlock machineBlock = (CustomMachineBlock)class_22482;
            class_2498 soundType = machineBlock.getSoundType(blockState, (class_4538)level, blockPos, (class_1297)player);
            level.method_8396(player, blockPos, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
            level.method_32888((class_1297)player, class_5712.field_28164, blockPos);
        }
        if (player == null || !player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }
}

