/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.guielement;

import com.mojang.datafixers.kinds.Applicative;
import dev.architectury.hooks.item.ItemStackHooks;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class FluidGuiElement
extends AbstractTexturedGuiElement
implements IComponentGuiElement<FluidMachineComponent> {
    private static final class_2960 BASE_FLUID_STORAGE_TEXTURE = new class_2960("custommachinery", "textures/gui/base_fluid_storage.png");
    public static final NamedCodec<FluidGuiElement> CODEC = NamedCodec.record(fluidGuiElement -> FluidGuiElement.makeBaseTexturedCodec(fluidGuiElement, BASE_FLUID_STORAGE_TEXTURE).and(fluidGuiElement.group(NamedCodec.STRING.fieldOf("id").forGetter(FluidGuiElement::getID), NamedCodec.BOOL.optionalFieldOf("highlight", true).forGetter(FluidGuiElement::highlight))).apply((Applicative)fluidGuiElement, FluidGuiElement::new), "Fluid gui element");
    private final String id;
    private final boolean highlight;

    public FluidGuiElement(int x, int y, int width, int height, int priority, class_2960 texture, String id, boolean highlight) {
        super(x, y, width, height, priority, texture);
        this.id = id;
        this.highlight = highlight;
    }

    public boolean highlight() {
        return this.highlight;
    }

    public GuiElementType<FluidGuiElement> getType() {
        return (GuiElementType)((Object)Registration.FLUID_GUI_ELEMENT.get());
    }

    @Override
    public MachineComponentType<FluidMachineComponent> getComponentType() {
        return (MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get());
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void handleClick(byte button, MachineTile tile, class_1703 container, class_3222 player) {
        class_1799 carried = container.method_34255();
        if (carried.method_7960() || !PlatformHelper.fluid().isFluidHandler(carried)) {
            return;
        }
        tile.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(this.id)).ifPresent(component -> {
            class_1799 stack = PlatformHelper.fluid().transferFluid(carried, (FluidMachineComponent)component);
            if (class_1799.method_7973((class_1799)stack, (class_1799)carried)) {
                return;
            }
            if (!player.method_7337()) {
                if (carried.method_7947() > 1) {
                    carried.method_7934(1);
                    container.method_34254(carried);
                    ItemStackHooks.giveItem((class_3222)player, (class_1799)stack);
                } else {
                    container.method_34254(stack);
                }
            }
        });
    }
}

