/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.crafting.ComponentNotFoundException;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.crafting.ProcessorType;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.api.requirement.IChanceableRequirement;
import fr.frinn.custommachinery.api.requirement.IDelayedRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.ITickableRequirement;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineRecipeFinder;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.DoubleSyncable;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MachineProcessor
implements IProcessor,
ISyncableStuff {
    private final MachineTile tile;
    private final Random rand = Utils.RAND;
    private final List<IRequirement<?>> processedRequirements;
    private final CraftingContext.Mutable mutableCraftingContext;
    private final int amount;
    private final int recipeCheckCooldown;
    private CustomMachineRecipe currentRecipe;
    private class_2960 futureRecipeID;
    private double recipeProgressTime = 0.0;
    private int recipeTotalTime = 0;
    private CraftingContext context;
    private boolean initialized = false;
    private List<ITickableRequirement<IMachineComponent>> tickableRequirements;
    private List<IDelayedRequirement<IMachineComponent>> delayedRequirements;
    private PHASE phase = PHASE.STARTING;
    private final MachineRecipeFinder recipeFinder;

    public MachineProcessor(MachineTile tile, int amount, int recipeCheckCooldown) {
        this.tile = tile;
        this.amount = amount;
        this.recipeCheckCooldown = recipeCheckCooldown;
        this.mutableCraftingContext = new CraftingContext.Mutable(this, tile.getUpgradeManager());
        this.processedRequirements = new ArrayList();
        this.recipeFinder = new MachineRecipeFinder(tile, recipeCheckCooldown);
    }

    @Override
    public void tick() {
        if (!this.initialized) {
            this.init();
        }
        if (this.currentRecipe == null) {
            this.searchForRecipe(false);
        }
        if (this.currentRecipe != null) {
            if (this.phase == PHASE.STARTING) {
                this.startProcess();
            }
            if (this.phase == PHASE.CRAFTING_TICKABLE) {
                this.processTickable();
            }
            if (this.phase == PHASE.CRAFTING_DELAYED) {
                this.processDelayed();
            }
            if (this.phase == PHASE.ENDING) {
                this.endProcess();
            }
        } else {
            this.tile.setStatus(MachineStatus.IDLE);
        }
    }

    private void init() {
        this.initialized = true;
        this.recipeFinder.init();
        if (this.futureRecipeID != null && this.tile.method_10997() != null) {
            this.tile.method_10997().method_8433().method_8130(this.futureRecipeID).filter(recipe -> recipe instanceof CustomMachineRecipe).map(recipe -> (CustomMachineRecipe)recipe).ifPresent(this::setOldRecipe);
            this.futureRecipeID = null;
        }
    }

    private void searchForRecipe(boolean immediately) {
        if (this.currentRecipe == null) {
            this.recipeFinder.findRecipe(this.mutableCraftingContext, immediately).ifPresent(this::setRecipe);
        }
    }

    private void startProcess() {
        for (IRequirement<?> requirement : this.currentRecipe.getRequirements()) {
            if (this.processedRequirements.contains(requirement)) continue;
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(requirement.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(this.currentRecipe, this.tile.getMachine(), requirement.getType()));
            if (requirement instanceof IChanceableRequirement && ((IChanceableRequirement)requirement).shouldSkip(component, this.rand, this.context)) {
                this.processedRequirements.add(requirement);
                continue;
            }
            CraftingResult result = requirement.processStart(component, this.context);
            if (!result.isSuccess()) {
                if (this.currentRecipe.shouldResetOnError()) {
                    this.reset();
                    return;
                }
                this.tile.setStatus(MachineStatus.ERRORED, result.getMessage());
                break;
            }
            this.processedRequirements.add(requirement);
        }
        if (this.processedRequirements.size() == this.currentRecipe.getRequirements().size()) {
            this.tile.setStatus(MachineStatus.RUNNING);
            this.phase = PHASE.CRAFTING_TICKABLE;
            this.processedRequirements.clear();
        }
    }

    private void processTickable() {
        for (ITickableRequirement<IMachineComponent> tickableRequirement : this.tickableRequirements) {
            if (this.processedRequirements.contains(tickableRequirement)) continue;
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(tickableRequirement.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(this.currentRecipe, this.tile.getMachine(), tickableRequirement.getType()));
            if (tickableRequirement instanceof IChanceableRequirement && ((IChanceableRequirement)((Object)tickableRequirement)).shouldSkip(component, this.rand, this.context)) {
                this.processedRequirements.add(tickableRequirement);
                continue;
            }
            CraftingResult result = tickableRequirement.processTick(component, this.context);
            if (!result.isSuccess()) {
                if (this.currentRecipe.shouldResetOnError()) {
                    this.reset();
                    return;
                }
                this.tile.setStatus(MachineStatus.ERRORED, result.getMessage());
                break;
            }
            this.processedRequirements.add(tickableRequirement);
        }
        if (this.processedRequirements.size() == this.tickableRequirements.size()) {
            this.recipeProgressTime += this.context.getModifiedSpeed();
            this.tile.setStatus(MachineStatus.RUNNING);
            this.processedRequirements.clear();
        }
        this.phase = PHASE.CRAFTING_DELAYED;
    }

    private void processDelayed() {
        Iterator<IDelayedRequirement<IMachineComponent>> iterator = this.delayedRequirements.iterator();
        while (iterator.hasNext()) {
            IDelayedRequirement<IMachineComponent> delayedRequirement2 = iterator.next();
            if (!(this.recipeProgressTime / (double)this.recipeTotalTime >= delayedRequirement2.getDelay())) continue;
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(delayedRequirement2.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(this.currentRecipe, this.tile.getMachine(), delayedRequirement2.getType()));
            CraftingResult result = delayedRequirement2.execute(component, this.context);
            if (!result.isSuccess()) {
                if (this.currentRecipe.shouldResetOnError()) {
                    this.reset();
                    return;
                }
                this.tile.setStatus(MachineStatus.ERRORED, result.getMessage());
                break;
            }
            iterator.remove();
        }
        if (this.delayedRequirements.stream().allMatch(delayedRequirement -> this.recipeProgressTime / (double)this.recipeTotalTime < delayedRequirement.getDelay())) {
            this.phase = this.recipeProgressTime >= (double)this.recipeTotalTime ? PHASE.ENDING : PHASE.CRAFTING_TICKABLE;
        }
    }

    private void endProcess() {
        for (IRequirement<?> requirement : this.currentRecipe.getRequirements()) {
            if (this.processedRequirements.contains(requirement)) continue;
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(requirement.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(this.currentRecipe, this.tile.getMachine(), requirement.getType()));
            if (requirement instanceof IChanceableRequirement && ((IChanceableRequirement)requirement).shouldSkip(component, this.rand, this.context)) {
                this.processedRequirements.add(requirement);
                continue;
            }
            CraftingResult result = requirement.processEnd(component, this.context);
            if (!result.isSuccess()) {
                if (this.currentRecipe.shouldResetOnError()) {
                    this.reset();
                    return;
                }
                this.tile.setStatus(MachineStatus.ERRORED, result.getMessage());
                break;
            }
            this.processedRequirements.add(requirement);
        }
        if (this.processedRequirements.size() == this.currentRecipe.getRequirements().size()) {
            this.currentRecipe = null;
            this.recipeProgressTime = 0.0;
            this.context = null;
            this.processedRequirements.clear();
            this.recipeFinder.setInventoryChanged(true);
            this.searchForRecipe(true);
        }
    }

    private void setRecipe(CustomMachineRecipe recipe) {
        this.currentRecipe = recipe;
        this.context = new CraftingContext(this, this.tile.getUpgradeManager(), recipe);
        this.tickableRequirements = this.currentRecipe.getRequirements().stream().filter(requirement -> requirement instanceof ITickableRequirement).map(requirement -> (ITickableRequirement)requirement).toList();
        this.delayedRequirements = this.currentRecipe.getRequirements().stream().filter(requirement -> requirement instanceof IDelayedRequirement).map(requirement -> (IDelayedRequirement)requirement).filter(requirement -> requirement.getDelay() > 0.0 && requirement.getDelay() < 1.0).toList();
        this.recipeTotalTime = this.currentRecipe.getRecipeTime();
        this.phase = PHASE.STARTING;
        this.tile.setStatus(MachineStatus.RUNNING);
    }

    private void setOldRecipe(CustomMachineRecipe recipe) {
        this.currentRecipe = recipe;
        this.context = new CraftingContext(this, this.tile.getUpgradeManager(), recipe);
        this.tickableRequirements = this.currentRecipe.getRequirements().stream().filter(requirement -> requirement instanceof ITickableRequirement).map(requirement -> (ITickableRequirement)requirement).toList();
        this.delayedRequirements = this.currentRecipe.getRequirements().stream().filter(requirement -> requirement instanceof IDelayedRequirement).map(requirement -> (IDelayedRequirement)requirement).filter(requirement -> requirement.getDelay() > 0.0 && requirement.getDelay() < 1.0).toList();
        this.recipeTotalTime = this.currentRecipe.getRecipeTime();
        this.tile.setStatus(MachineStatus.RUNNING);
    }

    @Override
    public void reset() {
        this.currentRecipe = null;
        this.futureRecipeID = null;
        this.tile.setStatus(MachineStatus.IDLE);
        this.recipeProgressTime = 0.0;
        this.recipeTotalTime = 0;
        this.processedRequirements.clear();
        this.context = null;
    }

    @Override
    public MachineTile getTile() {
        return this.tile;
    }

    public CustomMachineRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    @Override
    public double getRecipeProgressTime() {
        return this.recipeProgressTime;
    }

    public int getRecipeTotalTime() {
        return this.recipeTotalTime;
    }

    @Override
    @Nullable
    public ICraftingContext getCurrentContext() {
        return this.context;
    }

    public ProcessorType<MachineProcessor> getType() {
        return (ProcessorType)((Object)Registration.MACHINE_PROCESSOR.get());
    }

    @Override
    public class_2487 serialize() {
        class_2487 nbt = new class_2487();
        nbt.method_10582("type", this.getType().getId().toString());
        if (this.currentRecipe != null) {
            nbt.method_10582("recipe", this.currentRecipe.method_8114().toString());
        }
        nbt.method_10582("phase", this.phase.toString());
        nbt.method_10549("recipeProgressTime", this.recipeProgressTime);
        return nbt;
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("type", 8) && !nbt.method_10558("type").equals(this.getType().getId().toString())) {
            return;
        }
        if (nbt.method_10573("recipe", 8)) {
            this.futureRecipeID = new class_2960(nbt.method_10558("recipe"));
        }
        if (nbt.method_10573("phase", 8)) {
            this.phase = PHASE.value(nbt.method_10558("phase"));
        }
        if (nbt.method_10573("recipeProgressTime", 6)) {
            this.recipeProgressTime = nbt.method_10574("recipeProgressTime");
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(DoubleSyncable.create(() -> this.recipeProgressTime, recipeProgressTime -> {
            this.recipeProgressTime = recipeProgressTime;
        }));
        container.accept(IntegerSyncable.create(() -> this.recipeTotalTime, recipeTotalTime -> {
            this.recipeTotalTime = recipeTotalTime;
        }));
    }

    @Override
    public void setMachineInventoryChanged() {
        this.recipeFinder.setInventoryChanged(true);
    }

    public static enum PHASE {
        STARTING,
        CRAFTING_TICKABLE,
        CRAFTING_DELAYED,
        ENDING;

        public static final NamedCodec<PHASE> CODEC;

        public static PHASE value(String string) {
            return PHASE.valueOf(string.toUpperCase(Locale.ENGLISH));
        }

        static {
            CODEC = NamedCodec.enumCodec(PHASE.class);
        }
    }

    public static class Template
    implements IProcessorTemplate<MachineProcessor> {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("amount", 1).forGetter(template -> template.amount), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("cooldown", 20).forGetter(template -> template.recipeCheckCooldown)).apply((Applicative)templateInstance, Template::new), "Machine processor");
        public static final Template DEFAULT = new Template(1, 20);
        private final int amount;
        private final int recipeCheckCooldown;

        private Template(int amount, int cooldown) {
            this.amount = amount;
            this.recipeCheckCooldown = cooldown;
        }

        @Override
        public ProcessorType<MachineProcessor> getType() {
            return (ProcessorType)((Object)Registration.MACHINE_PROCESSOR.get());
        }

        @Override
        public MachineProcessor build(MachineTile tile) {
            return new MachineProcessor(tile, this.amount, this.recipeCheckCooldown);
        }
    }
}

