/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.core.RegistryEntry;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipeBuilder;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomMachineRecipeSerializer
extends RegistryEntry<CustomMachineRecipeSerializer>
implements class_1865<CustomMachineRecipe> {
    public CustomMachineRecipe fromJson(class_2960 recipeId, JsonObject json) {
        ICustomMachineryAPI.INSTANCE.logger().info("Parsing recipe json: {}", (Object)recipeId);
        DataResult<Pair<CustomMachineRecipeBuilder, JsonObject>> result = CustomMachineRecipeBuilder.CODEC.decode(JsonOps.INSTANCE, json);
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Successfully read recipe json: {}", (Object)recipeId);
            return ((CustomMachineRecipeBuilder)((Pair)result.result().get()).getFirst()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new JsonParseException("Error while parsing Custom Machine Recipe json: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when parsing Custom Machine Recipe json: " + recipeId + "This can't happen");
    }

    @Nullable
    public CustomMachineRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        ICustomMachineryAPI.INSTANCE.logger().info("Receiving recipe: {} from server.", (Object)recipeId);
        DataResult<CustomMachineRecipeBuilder> result = CustomMachineRecipeBuilder.CODEC.read(class_2509.field_11560, buffer.method_30617());
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully received recipe: {} from server.", (Object)recipeId);
            return ((CustomMachineRecipeBuilder)result.result().get()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while receiving Custom Machine Recipe from server: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when receiving Custom Machine Recipe: " + recipeId + "from server. This can't happen");
    }

    public void toNetwork(class_2540 buffer, CustomMachineRecipe recipe) {
        ICustomMachineryAPI.INSTANCE.logger().info("Sending recipe: {} to clients", (Object)recipe.method_8114());
        DataResult result = CustomMachineRecipeBuilder.CODEC.encodeStart(class_2509.field_11560, new CustomMachineRecipeBuilder(recipe));
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully send recipe: {} to clients.", (Object)recipe.method_8114());
            buffer.method_10794((class_2487)result.result().get());
            return;
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while sending recipe: {} to clients.%n{}", (Object)recipe.method_8114(), (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while sending Custom Machine Recipe to clients: " + recipe.method_8114() + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when sending Custom Machine Recipe: " + recipe.method_8114() + "to clients. This can't happen");
    }
}

