/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.crafting.AbstractRecipeBuilder;
import java.util.Collections;
import net.minecraft.class_2960;

public class CustomMachineRecipeBuilder
extends AbstractRecipeBuilder<CustomMachineRecipe> {
    public static final NamedCodec<CustomMachineRecipeBuilder> CODEC = NamedCodec.record(recipeBuilderInstance -> recipeBuilderInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("machine").forGetter(AbstractRecipeBuilder::getMachine), NamedCodec.INT.fieldOf("time").forGetter(builder -> builder.time), IRequirement.CODEC.listOf().optionalFieldOf("requirements", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getRequirements), IRequirement.CODEC.listOf().optionalFieldOf("jei", Collections.emptyList()).forGetter(AbstractRecipeBuilder::getJeiRequirements), NamedCodec.INT.optionalFieldOf("priority", 0).forGetter(AbstractRecipeBuilder::getPriority), NamedCodec.INT.optionalFieldOf("jeiPriority", 0).forGetter(AbstractRecipeBuilder::getJeiPriority), NamedCodec.BOOL.optionalFieldOf("error", true).forGetter(builder -> !builder.resetOnError), NamedCodec.BOOL.optionalFieldOf("hidden", false).forGetter(AbstractRecipeBuilder::isHidden)).apply((Applicative)recipeBuilderInstance, (machine, time, requirements, jeiRequirements, priority, jeiPriority, error, hidden) -> {
        CustomMachineRecipeBuilder builder = new CustomMachineRecipeBuilder((class_2960)machine, (int)time);
        requirements.forEach(builder::withRequirement);
        jeiRequirements.forEach(builder::withJeiRequirement);
        builder.withPriority((int)priority);
        builder.withJeiPriority((int)jeiPriority);
        if (!error.booleanValue()) {
            builder.setResetOnError();
        }
        if (hidden.booleanValue()) {
            builder.hide();
        }
        return builder;
    }), "Machine recipe builder");
    private final int time;
    private boolean resetOnError = false;

    public CustomMachineRecipeBuilder(class_2960 machine, int time) {
        super(machine);
        this.time = time;
    }

    public CustomMachineRecipeBuilder(CustomMachineRecipe recipe) {
        super(recipe);
        this.time = recipe.getRecipeTime();
        this.resetOnError = recipe.shouldResetOnError();
    }

    public CustomMachineRecipeBuilder setResetOnError() {
        this.resetOnError = true;
        return this;
    }

    @Override
    public CustomMachineRecipe build(class_2960 id) {
        return new CustomMachineRecipe(id, this.getMachine(), this.time, this.getRequirements(), this.getJeiRequirements(), this.getPriority(), this.getJeiPriority(), this.resetOnError, this.isHidden());
    }

    public String toString() {
        return "CustomMachineRecipe{machine=" + this.getMachine() + ", time=" + this.time + ", requirements=" + this.getRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", jeiRequirements=" + this.getJeiRequirements().stream().map(requirement -> requirement.getType().getId()).toList() + ", priority=" + this.getPriority() + ", jeiPriority=" + this.getJeiPriority() + ", resetOnError=" + this.resetOnError + ", hidden=" + this.isHidden() + "}";
    }
}

