/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.google.common.base.Suppliers;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfoRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.crafting.RecipeChecker;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class CustomMachineRecipe
implements class_1860<class_1263>,
IMachineRecipe {
    private final class_2960 id;
    private final class_2960 machine;
    private final int time;
    private final List<IRequirement<?>> requirements;
    private final List<IRequirement<?>> jeiRequirements;
    private final int priority;
    private final int jeiPriority;
    private final boolean resetOnError;
    private final boolean hidden;
    private final Supplier<RecipeChecker<CustomMachineRecipe>> checker = Suppliers.memoize(() -> new RecipeChecker<CustomMachineRecipe>(this));

    public CustomMachineRecipe(class_2960 id, class_2960 machine, int time, List<IRequirement<?>> requirements, List<IRequirement<?>> jeiRequirements, int priority, int jeiPriority, boolean resetOnError, boolean hidden) {
        this.id = id;
        this.machine = machine;
        this.time = time;
        this.requirements = requirements.stream().sorted(Comparators.REQUIREMENT_COMPARATOR).toList();
        this.jeiRequirements = jeiRequirements;
        this.priority = priority;
        this.jeiPriority = jeiPriority;
        this.resetOnError = resetOnError;
        this.hidden = hidden;
    }

    @Override
    public class_2960 getMachineId() {
        return this.machine;
    }

    public class_2960 method_8114() {
        return this.getRecipeId();
    }

    @Override
    public class_2960 getRecipeId() {
        return this.id;
    }

    @Override
    public int getRecipeTime() {
        return this.time;
    }

    @Override
    public List<IRequirement<?>> getRequirements() {
        return this.requirements;
    }

    @Override
    public List<IRequirement<?>> getJeiRequirements() {
        return this.jeiRequirements;
    }

    public List<IJEIIngredientRequirement<?>> getJEIIngredientRequirements() {
        if (this.jeiRequirements.isEmpty()) {
            return this.requirements.stream().filter(requirement -> requirement instanceof IJEIIngredientRequirement).map(requirement -> (IJEIIngredientRequirement)((Object)requirement)).collect(Collectors.toList());
        }
        return this.jeiRequirements.stream().filter(requirement -> requirement instanceof IJEIIngredientRequirement).map(requirement -> (IJEIIngredientRequirement)((Object)requirement)).collect(Collectors.toList());
    }

    @Override
    public List<IDisplayInfoRequirement> getDisplayInfoRequirements() {
        if (this.jeiRequirements.isEmpty()) {
            return this.requirements.stream().filter(requirement -> requirement instanceof IDisplayInfoRequirement).map(requirement -> (IDisplayInfoRequirement)((Object)requirement)).toList();
        }
        return this.jeiRequirements.stream().filter(requirement -> requirement instanceof IDisplayInfoRequirement).map(requirement -> (IDisplayInfoRequirement)((Object)requirement)).toList();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int getJeiPriority() {
        return this.jeiPriority;
    }

    @Override
    public boolean shouldResetOnError() {
        return this.resetOnError;
    }

    @Override
    public boolean showInJei() {
        return !this.hidden;
    }

    public RecipeChecker<CustomMachineRecipe> checker() {
        return this.checker.get();
    }

    public class_1865<?> method_8119() {
        return (class_1865)Registration.CUSTOM_MACHINE_RECIPE_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)Registration.CUSTOM_MACHINE_RECIPE.get();
    }

    public boolean method_8115(class_1263 inv, class_1937 worldIn) {
        return false;
    }

    public class_1799 method_8116(class_1263 inv) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110() {
        return class_1799.field_8037;
    }
}

