/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import dev.architectury.core.RegistryEntry;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipeBuilder;
import net.minecraft.class_1865;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomCraftRecipeSerializer
extends RegistryEntry<CustomCraftRecipeSerializer>
implements class_1865<CustomCraftRecipe> {
    public CustomCraftRecipe fromJson(class_2960 recipeId, JsonObject json) {
        ICustomMachineryAPI.INSTANCE.logger().info("Parsing craft recipe json: {}", (Object)recipeId);
        DataResult<Pair<CustomCraftRecipeBuilder, JsonObject>> result = CustomCraftRecipeBuilder.CODEC.decode(JsonOps.INSTANCE, json);
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Successfully read craft recipe json: {}", (Object)recipeId);
            return ((CustomCraftRecipeBuilder)((Pair)result.result().get()).getFirst()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing craft recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new JsonParseException("Error while parsing Custom Machine Craft Recipe json: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when parsing Custom Machine Craft Recipe json: " + recipeId + "This can't happen");
    }

    @Nullable
    public CustomCraftRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
        ICustomMachineryAPI.INSTANCE.logger().info("Receiving craft recipe: {} from server.", (Object)recipeId);
        DataResult<CustomCraftRecipeBuilder> result = CustomCraftRecipeBuilder.CODEC.read(class_2509.field_11560, buffer.method_30617());
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully received craft recipe: {} from server.", (Object)recipeId);
            return ((CustomCraftRecipeBuilder)result.result().get()).build(recipeId);
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing craft recipe json: {}, skipping...\n{}", (Object)recipeId, (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while receiving Custom Machine Craft Recipe from server: " + recipeId + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when receiving Custom Machine Craft Recipe: " + recipeId + "from server. This can't happen");
    }

    public void toNetwork(class_2540 buffer, CustomCraftRecipe recipe) {
        ICustomMachineryAPI.INSTANCE.logger().info("Sending craft recipe: {} to clients", (Object)recipe.method_8114());
        DataResult result = CustomCraftRecipeBuilder.CODEC.encodeStart(class_2509.field_11560, new CustomCraftRecipeBuilder(recipe));
        if (result.result().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().info("Sucessfully send craft recipe: {} to clients.", (Object)recipe.method_8114());
            buffer.method_10794((class_2487)result.result().get());
            return;
        }
        if (result.error().isPresent()) {
            ICustomMachineryAPI.INSTANCE.logger().error("Error while sending craft recipe: {} to clients.%n{}", (Object)recipe.method_8114(), (Object)((DataResult.PartialResult)result.error().get()).message());
            throw new IllegalArgumentException("Error while sending Custom Machine Craft Recipe to clients: " + recipe.method_8114() + " error: " + ((DataResult.PartialResult)result.error().get()).message());
        }
        throw new IllegalStateException("No success nor error when sending Custom Machine Craft Recipe: " + recipe.method_8114() + "to clients. This can't happen");
    }
}

