/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.craft;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.ComponentNotFoundException;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.crafting.ProcessorType;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.requirement.IChanceableRequirement;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.common.component.variant.item.ResultItemComponentVariant;
import fr.frinn.custommachinery.common.crafting.CraftingContext;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

public class CraftProcessor
implements IProcessor {
    private final MachineTile tile;
    private final Random rand = Utils.RAND;
    private boolean shouldCheck = true;
    @Nullable
    private CraftingContext currentContext;
    @Nullable
    private CustomCraftRecipe currentRecipe;

    public CraftProcessor(MachineTile tile) {
        this.tile = tile;
    }

    @Override
    @Nullable
    public ICraftingContext getCurrentContext() {
        return this.currentContext;
    }

    public ProcessorType<CraftProcessor> getType() {
        return (ProcessorType)((Object)Registration.CRAFT_PROCESSOR.get());
    }

    @Override
    public MachineTile getTile() {
        return this.tile;
    }

    @Override
    public double getRecipeProgressTime() {
        return 0.0;
    }

    @Override
    public void tick() {
        if (this.shouldCheck) {
            this.shouldCheck = false;
            if (this.currentRecipe != null && this.currentContext != null) {
                if (this.checkRecipe(this.currentRecipe, this.currentContext)) {
                    return;
                }
                this.reset();
            }
            this.findRecipe().ifPresent(this::setCurrentRecipe);
        }
    }

    @Override
    public void setMachineInventoryChanged() {
        this.shouldCheck = true;
    }

    public void craft() {
        if (this.currentRecipe == null || this.currentContext == null) {
            return;
        }
        this.processRecipe(this.currentRecipe, this.currentContext);
        this.reset();
    }

    public boolean bulkCraft() {
        if (this.currentRecipe == null || this.currentContext == null) {
            return false;
        }
        this.processRecipe(this.currentRecipe, this.currentContext);
        if (this.checkRecipe(this.currentRecipe, this.currentContext)) {
            this.setCurrentRecipe(this.currentRecipe);
            return true;
        }
        this.reset();
        return false;
    }

    private Optional<CustomCraftRecipe> findRecipe() {
        if (this.tile.method_10997() == null) {
            return Optional.empty();
        }
        List<CustomCraftRecipe> recipes = this.tile.method_10997().method_8433().method_30027((class_3956)Registration.CUSTOM_CRAFT_RECIPE.get()).stream().filter(recipe -> recipe.getMachineId().equals((Object)this.tile.getMachine().getId())).toList();
        CraftingContext.Mutable context = new CraftingContext.Mutable(this, this.tile.getUpgradeManager());
        for (CustomCraftRecipe recipe2 : recipes) {
            context.setRecipe(recipe2);
            if (!this.checkRecipe(recipe2, context)) continue;
            return Optional.of(recipe2);
        }
        return Optional.empty();
    }

    private boolean checkRecipe(CustomCraftRecipe recipe, CraftingContext context) {
        return recipe.getRequirements().stream().allMatch(requirement -> {
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(requirement.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(recipe, this.tile.getMachine(), requirement.getType()));
            return requirement.test(component, context);
        });
    }

    private void setCurrentRecipe(CustomCraftRecipe recipe) {
        this.currentRecipe = recipe;
        this.currentContext = new CraftingContext(this, this.tile.getUpgradeManager(), recipe);
        this.tile.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getVariant() == ResultItemComponentVariant.INSTANCE).findFirst()).ifPresent(component -> component.setItemStack(recipe.getOutput().method_7972()));
    }

    private void processRecipe(CustomCraftRecipe recipe, CraftingContext context) {
        for (IRequirement<?> requirement : recipe.getRequirements()) {
            IChanceableRequirement chanceable;
            IMachineComponent component = (IMachineComponent)this.tile.getComponentManager().getComponent(requirement.getComponentType()).orElseThrow(() -> new ComponentNotFoundException(recipe, this.tile.getMachine(), requirement.getType()));
            if (requirement instanceof IChanceableRequirement && (chanceable = (IChanceableRequirement)requirement).shouldSkip(component, this.rand, context)) continue;
            requirement.processStart(component, context);
            requirement.processEnd(component, context);
        }
    }

    @Override
    public void reset() {
        this.currentRecipe = null;
        this.currentContext = null;
        this.tile.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponents().stream().filter(component -> component.getVariant() == ResultItemComponentVariant.INSTANCE).findFirst()).ifPresent(component -> component.setItemStack(class_1799.field_8037));
    }

    @Override
    public class_2487 serialize() {
        return new class_2487();
    }

    @Override
    public void deserialize(class_2487 nbt) {
    }

    public static class Template
    implements IProcessorTemplate<CraftProcessor> {
        public static final NamedCodec<Template> CODEC = NamedCodec.unit(Template::new, "Craft processor");

        @Override
        public ProcessorType<CraftProcessor> getType() {
            return (ProcessorType)((Object)Registration.CRAFT_PROCESSOR.get());
        }

        @Override
        public CraftProcessor build(MachineTile tile) {
            return new CraftProcessor(tile);
        }
    }
}

