/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.upgrade.IMachineUpgradeManager;
import fr.frinn.custommachinery.api.upgrade.IRecipeModifier;
import fr.frinn.custommachinery.common.component.variant.item.UpgradeItemComponentVariant;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import java.util.ArrayList;
import java.util.List;

public class UpgradeManager
implements IMachineUpgradeManager {
    private final CustomMachineTile tile;
    private final List<Pair<IRecipeModifier, Integer>> activeModifiers = new ArrayList<Pair<IRecipeModifier, Integer>>();
    private boolean isDirty = true;

    public UpgradeManager(CustomMachineTile tile) {
        this.tile = tile;
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    private void refreshUpgrades() {
        this.isDirty = false;
        this.activeModifiers.clear();
        this.activeModifiers.addAll(this.tile.getComponentManager().getComponentHandler((MachineComponentType)((Object)Registration.ITEM_MACHINE_COMPONENT.get())).stream().flatMap(handler -> handler.getComponents().stream()).filter(slot -> slot.getVariant() == UpgradeItemComponentVariant.INSTANCE && !slot.getItemStack().method_7960()).flatMap(slot -> CustomMachinery.UPGRADES.getUpgradesForItemAndMachine(slot.getItemStack().method_7909(), this.tile.getMachine().getId()).stream().flatMap(upgrade -> upgrade.getModifiers().stream().map(modifier -> Pair.of((Object)modifier, (Object)Math.min(slot.getItemStack().method_7947(), upgrade.getMaxAmount()))))).toList());
    }

    @Override
    public List<Pair<IRecipeModifier, Integer>> getAllModifiers() {
        if (this.isDirty) {
            this.refreshUpgrades();
        }
        return this.activeModifiers;
    }
}

