/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.variant.item;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.handler.IComponentHandler;
import fr.frinn.custommachinery.api.component.variant.ITickableComponentVariant;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.transfer.IFluidHelper;
import fr.frinn.custommachinery.impl.component.variant.ItemComponentVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class FluidItemComponentVariant
extends ItemComponentVariant
implements ITickableComponentVariant<ItemMachineComponent> {
    public static final NamedCodec<FluidItemComponentVariant> CODEC = NamedCodec.record(variantInstance -> variantInstance.group(NamedCodec.STRING.listOf().optionalFieldOf("tanks", Collections.emptyList()).forGetter(variant -> variant.tanks)).apply((Applicative)variantInstance, FluidItemComponentVariant::new), "Fluid item component variant");
    public static final class_2960 ID = new class_2960("custommachinery", "fluid");
    private final List<String> tanks;

    public FluidItemComponentVariant(List<String> tanks) {
        this.tanks = tanks;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    public NamedCodec<FluidItemComponentVariant> getCodec() {
        return CODEC;
    }

    @Override
    public boolean canAccept(IMachineComponentManager manager, class_1799 stack) {
        return PlatformHelper.fluid().isFluidHandler(stack);
    }

    @Override
    public void tick(ItemMachineComponent component) {
        class_1799 stack = component.getItemStack();
        if (!PlatformHelper.fluid().isFluidHandler(stack)) {
            return;
        }
        IFluidHelper helper = PlatformHelper.fluid();
        ArrayList<FluidMachineComponent> tanks = new ArrayList<FluidMachineComponent>();
        if (this.tanks.isEmpty()) {
            tanks.addAll(component.getManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).map(IComponentHandler::getComponents).orElse(Collections.emptyList()));
        } else {
            for (String tank : this.tanks) {
                component.getManager().getComponentHandler((MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get())).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(tanks::add);
            }
        }
        if (component.getMode().isInput()) {
            helper.fillTanksFromStack(tanks, component);
        } else if (component.getMode().isOutput()) {
            helper.fillStackFromTanks(component, tanks);
        }
    }
}

