/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.handler;

import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.PlatformHelper;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.transfer.ICommonFluidHandler;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3611;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class FluidComponentHandler
extends AbstractComponentHandler<FluidMachineComponent>
implements ISerializableComponent,
ISyncableStuff,
ITickableComponent,
IDumpComponent {
    private final ICommonFluidHandler handler = PlatformHelper.createFluidHandler(this);
    private final List<FluidMachineComponent> inputs = new ArrayList<FluidMachineComponent>();
    private final List<FluidMachineComponent> outputs = new ArrayList<FluidMachineComponent>();

    public FluidComponentHandler(IMachineComponentManager manager, List<FluidMachineComponent> components) {
        super(manager, components);
        components.forEach(component -> {
            component.getConfig().setCallback((TriConsumer<RelativeSide, SideMode, SideMode>)((TriConsumer)this.handler::configChanged));
            if (component.getMode().isInput()) {
                this.inputs.add((FluidMachineComponent)component);
            }
            if (component.getMode().isOutput()) {
                this.outputs.add((FluidMachineComponent)component);
            }
        });
    }

    public ICommonFluidHandler getCommonFluidHandler() {
        return this.handler;
    }

    public MachineComponentType<FluidMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get());
    }

    @Override
    public Optional<FluidMachineComponent> getComponentForID(String id) {
        return this.getComponents().stream().filter(component -> component.getId().equals(id)).findFirst();
    }

    @Override
    public void onRemoved() {
        this.handler.invalidate();
    }

    @Override
    public void serverTick() {
        this.handler.tick();
    }

    @Override
    public void serialize(class_2487 nbt) {
        class_2499 componentsNBT = new class_2499();
        this.getComponents().forEach(component -> {
            class_2487 componentNBT = new class_2487();
            component.serialize(componentNBT);
            componentNBT.method_10582("id", component.getId());
            componentsNBT.add((Object)componentNBT);
        });
        nbt.method_10566("fluids", (class_2520)componentsNBT);
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("fluids", 9)) {
            class_2499 componentsNBT = nbt.method_10554("fluids", 10);
            componentsNBT.forEach(inbt -> {
                class_2487 componentNBT;
                if (inbt instanceof class_2487 && (componentNBT = (class_2487)inbt).method_10573("id", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.method_10558("id"))).findFirst().ifPresent(component -> component.deserialize(componentNBT));
                }
            });
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getComponents().forEach(component -> component.getStuffToSync(container));
    }

    @Override
    public void dump(List<String> ids) {
        this.getComponents().stream().filter(component -> ids.contains(component.getId())).forEach(component -> component.setFluidStack(FluidStack.empty()));
    }

    public long fill(FluidStack fluid, boolean simulate) {
        AtomicLong remaining = new AtomicLong(fluid.getAmount());
        this.getComponents().stream().filter(component -> component.isFluidValid(fluid) && component.getRemainingSpace() > 0L && component.getMode().isInput()).sorted(Comparator.comparingInt(component -> component.getFluidStack().isFluidEqual(fluid) ? -1 : 1)).forEach(component -> {
            long toInput = Math.min(remaining.get(), component.insert(fluid.getFluid(), fluid.getAmount(), fluid.getTag(), true));
            if (toInput > 0L) {
                remaining.addAndGet(-toInput);
                if (!simulate) {
                    component.insert(fluid.getFluid(), toInput, fluid.getTag(), false);
                }
            }
        });
        return fluid.getAmount() - remaining.get();
    }

    public FluidStack drain(FluidStack maxDrain, boolean simulate) {
        long remainingToDrain = maxDrain.getAmount();
        for (FluidMachineComponent component : this.getComponents()) {
            if (component.getFluidStack().isEmpty() || !component.getFluidStack().isFluidEqual(maxDrain) || !component.getMode().isOutput()) continue;
            FluidStack stack = component.extract(maxDrain.getAmount(), true);
            if (stack.getAmount() >= remainingToDrain) {
                if (!simulate) {
                    component.extract(remainingToDrain, false);
                }
                return maxDrain;
            }
            if (!simulate) {
                component.extract(stack.getAmount(), false);
            }
            remainingToDrain -= stack.getAmount();
        }
        if (remainingToDrain == maxDrain.getAmount()) {
            return FluidStack.empty();
        }
        return FluidStack.create((class_3611)maxDrain.getFluid(), (long)(maxDrain.getAmount() - remainingToDrain), (class_2487)maxDrain.getTag());
    }

    public long getFluidAmount(String tank, class_3611 fluid, @Nullable class_2487 nbt) {
        Predicate<FluidMachineComponent> nbtPredicate = component -> nbt == null || nbt.method_33133() || component.getFluidStack().getTag() != null && Utils.testNBT(component.getFluidStack().getTag(), nbt);
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.inputs.stream().filter(component -> component.getFluidStack().getFluid() == fluid && nbtPredicate.test((FluidMachineComponent)component) && tankPredicate.test((FluidMachineComponent)component)).mapToLong(component -> component.getFluidStack().getAmount()).sum();
    }

    public long getSpaceForFluid(String tank, class_3611 fluid, @Nullable class_2487 nbt) {
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.outputs.stream().filter(component -> component.isFluidValid(FluidStack.create((class_3611)fluid, (long)1L, (class_2487)nbt)) && tankPredicate.test((FluidMachineComponent)component)).mapToLong(FluidMachineComponent::getRecipeRemainingSpace).sum();
    }

    public void removeFromInputs(String tank, FluidStack stack) {
        AtomicLong toRemove = new AtomicLong(stack.getAmount());
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.inputs.stream().filter(component -> component.getFluidStack().getFluid() == stack.getFluid() && tankPredicate.test((FluidMachineComponent)component)).forEach(component -> {
            long maxExtract = Math.min(component.getFluidStack().getAmount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.recipeExtract(maxExtract);
        });
    }

    public void addToOutputs(String tank, FluidStack stack) {
        AtomicLong toAdd = new AtomicLong(stack.getAmount());
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.outputs.stream().filter(component -> component.isFluidValid(stack) && tankPredicate.test((FluidMachineComponent)component)).sorted(Comparator.comparingInt(component -> component.getFluidStack().isFluidEqual(stack) ? -1 : 1)).forEach(component -> {
            long maxInsert = Math.min(component.getRecipeRemainingSpace(), toAdd.get());
            toAdd.addAndGet(-maxInsert);
            component.recipeInsert(stack.getFluid(), maxInsert, stack.getTag());
        });
    }
}

