/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.mojang.datafixers.kinds.Applicative;
import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.FluidStackSyncable;
import fr.frinn.custommachinery.common.network.syncable.SideConfigSyncable;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public class FluidMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent {
    private final String id;
    private final long capacity;
    private final long maxInput;
    private final long maxOutput;
    private final List<IIngredient<class_3611>> filter;
    private final boolean whitelist;
    private final SideConfig config;
    private FluidStack fluidStack = FluidStack.empty();

    public FluidMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, long capacity, long maxInput, long maxOutput, List<IIngredient<class_3611>> filter, boolean whitelist, SideConfig.Template configTemplate) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.whitelist = whitelist;
        this.config = configTemplate.build(this);
    }

    public MachineComponentType<FluidMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public long getMaxInput() {
        return this.maxInput;
    }

    public long getMaxOutput() {
        return this.maxOutput;
    }

    @Override
    public SideConfig getConfig() {
        return this.config;
    }

    @Override
    public void serialize(class_2487 nbt) {
        if (!this.fluidStack.isEmpty()) {
            nbt.method_10566("stack", (class_2520)this.fluidStack.write(new class_2487()));
        }
        nbt.method_10566("config", this.config.serialize());
    }

    @Override
    public void deserialize(class_2487 nbt) {
        if (nbt.method_10573("stack", 10)) {
            this.fluidStack = FluidStack.read((class_2487)nbt.method_10562("stack"));
        }
        if (nbt.method_10545("config")) {
            this.config.deserialize(nbt.method_10580("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(FluidStackSyncable.create(() -> this.fluidStack, fluidStack -> {
            this.fluidStack = fluidStack;
        }));
        container.accept(SideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.fluidStack.getAmount() / (double)this.capacity));
    }

    public FluidStack getFluidStack() {
        return this.fluidStack.copy();
    }

    public void setFluidStack(FluidStack fluidStack) {
        this.fluidStack = fluidStack.copy();
        this.getManager().markDirty();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getRemainingSpace() {
        if (!this.fluidStack.isEmpty()) {
            return Math.min(this.capacity - this.fluidStack.getAmount(), this.getMaxInput());
        }
        return Math.min(this.capacity, this.getMaxInput());
    }

    public boolean isFluidValid(@NotNull FluidStack stack) {
        return this.filter.stream().anyMatch(ingredient -> ingredient.test(stack.getFluid())) == this.whitelist && (this.fluidStack.isEmpty() || stack.isFluidEqual(this.fluidStack));
    }

    public long insert(class_3611 fluid, long amount, class_2487 nbt, boolean simulate) {
        if (amount <= 0L) {
            return 0L;
        }
        if (this.fluidStack.isEmpty()) {
            amount = Math.min(amount, this.getMaxInput());
            if (!simulate) {
                this.fluidStack = FluidStack.create((class_3611)fluid, (long)amount, (class_2487)nbt);
                this.getManager().markDirty();
            }
        } else {
            amount = Math.min(Math.min(this.getRemainingSpace(), this.getMaxInput()), amount);
            if (!simulate) {
                this.fluidStack.grow(amount);
                this.getManager().markDirty();
            }
        }
        return amount;
    }

    public FluidStack extract(long amount, boolean simulate) {
        if (amount <= 0L || this.fluidStack.isEmpty()) {
            return FluidStack.empty();
        }
        amount = class_3532.method_24156((long)amount, (long)0L, (long)Math.min(this.fluidStack.getAmount(), this.getMaxOutput()));
        FluidStack removed = FluidStack.create((class_3611)this.fluidStack.getFluid(), (long)amount, (class_2487)this.fluidStack.getTag());
        if (!simulate) {
            this.fluidStack.shrink(amount);
            this.getManager().markDirty();
        }
        return removed;
    }

    public long getRecipeRemainingSpace() {
        if (!this.fluidStack.isEmpty()) {
            return this.capacity - this.fluidStack.getAmount();
        }
        return this.capacity;
    }

    public void recipeInsert(class_3611 fluid, long amount, class_2487 nbt) {
        if (amount <= 0L) {
            return;
        }
        if (this.fluidStack.isEmpty()) {
            this.fluidStack = FluidStack.create((class_3611)fluid, (long)amount, (class_2487)nbt);
        } else {
            amount = class_3532.method_24156((long)amount, (long)0L, (long)this.getRecipeRemainingSpace());
            this.fluidStack.grow(amount);
        }
        this.getManager().markDirty();
    }

    public void recipeExtract(long amount) {
        if (amount <= 0L) {
            return;
        }
        amount = class_3532.method_24156((long)amount, (long)0L, (long)this.fluidStack.getAmount());
        this.fluidStack.shrink(amount);
        this.getManager().markDirty();
    }

    public static class Template
    implements IMachineComponentTemplate<FluidMachineComponent> {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(fluidMachineComponentTemplate -> fluidMachineComponentTemplate.group(NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), NamedCodec.LONG.fieldOf("capacity").forGetter(template -> template.capacity), NamedCodec.LONG.optionalFieldOf("maxInput").forGetter(template -> Optional.of(template.maxInput)), NamedCodec.LONG.optionalFieldOf("maxOutput").forGetter(template -> Optional.of(template.maxOutput)), IIngredient.FLUID.listOf().optionalFieldOf("filter", Collections.emptyList()).forGetter(template -> template.filter), NamedCodec.BOOL.optionalFieldOf("whitelist", false).forGetter(template -> template.whitelist), ComponentIOMode.CODEC.optionalFieldOf("mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), SideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> Optional.of(template.config))).apply((Applicative)fluidMachineComponentTemplate, (id, capacity, maxInput, maxOutput, filter, whitelist, mode, config) -> new Template((String)id, (long)capacity, maxInput.orElse(capacity), maxOutput.orElse(capacity), (List<IIngredient<class_3611>>)filter, (boolean)whitelist, (ComponentIOMode)((Object)((Object)mode)), config.orElse(mode.getBaseConfig()))), "Fluid machine component");
        private final String id;
        private final long capacity;
        private final long maxInput;
        private final long maxOutput;
        private final List<IIngredient<class_3611>> filter;
        private final boolean whitelist;
        private final ComponentIOMode mode;
        private final SideConfig.Template config;

        public Template(String id, long capacity, long maxInput, long maxOutput, List<IIngredient<class_3611>> filter, boolean whitelist, ComponentIOMode mode, SideConfig.Template config) {
            this.id = id;
            this.capacity = capacity;
            this.maxInput = maxInput;
            this.maxOutput = maxOutput;
            this.filter = filter;
            this.whitelist = whitelist;
            this.mode = mode;
            this.config = config;
        }

        @Override
        public MachineComponentType<FluidMachineComponent> getType() {
            return (MachineComponentType)((Object)Registration.FLUID_MACHINE_COMPONENT.get());
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (isInput && !this.mode.isInput() || !isInput && !this.mode.isOutput()) {
                return false;
            }
            if (ingredient instanceof FluidStack) {
                FluidStack stack = (FluidStack)ingredient;
                return this.filter.stream().flatMap(f -> f.getAll().stream()).anyMatch(f -> f == stack.getFluid()) == this.whitelist;
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof FluidStack) {
                        FluidStack stack = (FluidStack)object;
                        return this.filter.stream().flatMap(f -> f.getAll().stream()).anyMatch(f -> f == stack.getFluid()) == this.whitelist;
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public FluidMachineComponent build(IMachineComponentManager manager) {
            return new FluidMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.maxOutput, this.filter, this.whitelist, this.config);
        }
    }
}

