/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.google.common.base.Suppliers;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.CustomMachineDamageSource;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;

public class EntityMachineComponent
extends AbstractMachineComponent {
    private final Supplier<CustomMachineDamageSource> damageSource = Suppliers.memoize(() -> new CustomMachineDamageSource(manager.getTile().getMachine().getName().getString()));

    public EntityMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<EntityMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.ENTITY_MACHINE_COMPONENT.get());
    }

    public int getEntitiesInRadius(int radius, Predicate<class_1297> filter) {
        class_2338 pos = this.getManager().getTile().method_11016();
        class_238 bb = new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius));
        return this.getManager().getLevel().method_8390(class_1297.class, bb, entity -> entity.method_5707(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius) && filter.test((class_1297)entity)).size();
    }

    public double getEntitiesInRadiusHealth(int radius, Predicate<class_1297> filter) {
        class_2338 pos = this.getManager().getTile().method_11016();
        class_238 bb = new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius));
        return this.getManager().getLevel().method_8390(class_1309.class, bb, entity -> filter.test((class_1297)entity) && entity.method_5707(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().mapToDouble(class_1309::method_6032).sum();
    }

    public void removeEntitiesHealth(int radius, Predicate<class_1297> filter, int amount) {
        class_2338 pos = this.getManager().getTile().method_11016();
        AtomicInteger toRemove = new AtomicInteger(amount);
        class_238 bb = new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius));
        this.getManager().getLevel().method_8390(class_1309.class, bb, entity -> filter.test((class_1297)entity) && entity.method_5707(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).forEach(entity -> {
            int maxRemove = Math.min((int)entity.method_6032(), toRemove.get());
            entity.method_5643((class_1282)this.damageSource.get(), (float)maxRemove);
            toRemove.addAndGet(-maxRemove);
        });
    }

    public void killEntities(int radius, Predicate<class_1297> filter, int amount) {
        class_2338 pos = this.getManager().getTile().method_11016();
        class_238 bb = new class_238((double)(pos.method_10263() - radius), (double)(pos.method_10264() - radius), (double)(pos.method_10260() - radius), (double)(pos.method_10263() + radius), (double)(pos.method_10264() + radius), (double)(pos.method_10260() + radius));
        this.getManager().getLevel().method_8390(class_1309.class, bb, entity -> filter.test((class_1297)entity) && entity.method_5707(Utils.vec3dFromBlockPos(pos)) <= (double)(radius * radius)).stream().limit(amount).forEach(entity -> entity.method_5643((class_1282)this.damageSource.get(), Float.MAX_VALUE));
    }
}

