/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;

public class DropMachineComponent
extends AbstractMachineComponent {
    public DropMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<DropMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.DROP_MACHINE_COMPONENT.get());
    }

    public int getItemAmount(List<IIngredient<class_1792>> items, double radius, boolean whitelist) {
        List filter = items.stream().flatMap(ingredient -> ingredient.getAll().stream()).toList();
        class_238 box = new class_238(this.getManager().getTile().method_11016().method_10080(radius, radius, radius), this.getManager().getTile().method_11016().method_10080(-radius, -radius, -radius));
        return this.getManager().getLevel().method_8390(class_1542.class, box, entity -> filter.contains(entity.method_6983().method_7909()) == whitelist && entity.method_24515().method_19771((class_2382)this.getManager().getTile().method_11016(), radius)).stream().mapToInt(entity -> entity.method_6983().method_7947()).sum();
    }

    public void consumeItem(List<IIngredient<class_1792>> items, int amount, double radius, boolean whitelist) {
        List filter = items.stream().flatMap(ingredient -> ingredient.getAll().stream()).toList();
        AtomicInteger toRemove = new AtomicInteger(amount);
        class_238 box = new class_238(this.getManager().getTile().method_11016().method_10080(radius, radius, radius), this.getManager().getTile().method_11016().method_10080(-radius, -radius, -radius));
        this.getManager().getLevel().method_8390(class_1542.class, box, entity -> filter.contains(entity.method_6983().method_7909()) == whitelist && entity.method_24515().method_19771((class_2382)this.getManager().getTile().method_11016(), radius)).forEach(entity -> {
            int maxRemove = Math.min(toRemove.get(), entity.method_6983().method_7947());
            if (maxRemove == entity.method_6983().method_7947()) {
                entity.method_5650(class_1297.class_5529.field_26999);
            } else {
                entity.method_6983().method_7934(maxRemove);
            }
            toRemove.addAndGet(-maxRemove);
        });
    }

    public boolean produceItem(class_1799 stack) {
        class_1937 world = this.getManager().getLevel();
        class_2338 pos = this.getManager().getTile().method_11016().method_10084();
        class_1542 entity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
        return world.method_8649((class_1297)entity);
    }
}

