/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2694;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_4538;

public class BlockMachineComponent
extends AbstractMachineComponent {
    public BlockMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<BlockMachineComponent> getType() {
        return (MachineComponentType)((Object)Registration.BLOCK_MACHINE_COMPONENT.get());
    }

    public long getBlockAmount(class_238 box, List<IIngredient<PartialBlockState>> filter, boolean whitelist) {
        box = Utils.rotateBox(box, (class_2350)this.getManager().getTile().method_11010().method_11654((class_2769)class_2741.field_12481));
        box = box.method_996(this.getManager().getTile().method_11016());
        return class_2338.method_29715((class_238)box).map(pos -> new class_2694((class_4538)this.getManager().getLevel(), pos, false)).filter(block -> filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test((class_2694)block)) == whitelist).count();
    }

    public boolean placeBlock(class_238 box, PartialBlockState block, int amount) {
        box = Utils.rotateBox(box, (class_2350)this.getManager().getTile().method_11010().method_11654((class_2769)class_2741.field_12481));
        box = box.method_996(this.getManager().getTile().method_11016());
        if (class_2338.method_29715((class_238)box).map(arg_0 -> ((class_1937)this.getManager().getLevel()).method_8320(arg_0)).filter(state -> state.method_26204() == class_2246.field_10124).count() < (long)amount) {
            return false;
        }
        AtomicInteger toPlace = new AtomicInteger(amount);
        class_2338.method_29715((class_238)box).forEach(pos -> {
            if (toPlace.get() > 0 && this.getManager().getLevel().method_8320(pos).method_26204() == class_2246.field_10124) {
                this.setBlock(this.getManager().getLevel(), (class_2338)pos, block);
                toPlace.addAndGet(-1);
            }
        });
        return true;
    }

    public boolean replaceBlock(class_238 box, PartialBlockState block, int amount, boolean drop, List<IIngredient<PartialBlockState>> filter, boolean whitelist) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (class_2350)this.getManager().getTile().method_11010().method_11654((class_2769)class_2741.field_12481));
        box = box.method_996(this.getManager().getTile().method_11016());
        AtomicInteger toPlace = new AtomicInteger(amount);
        class_2338.method_29715((class_238)box).forEach(pos -> {
            if (toPlace.get() > 0) {
                class_2694 cached = new class_2694((class_4538)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (cached.method_11681().method_26207() != class_3614.field_15959) {
                        this.getManager().getLevel().method_22352(pos, drop);
                    }
                    this.setBlock(this.getManager().getLevel(), (class_2338)pos, block);
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    public boolean breakBlock(class_238 box, List<IIngredient<PartialBlockState>> filter, boolean whitelist, int amount, boolean drop) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (class_2350)this.getManager().getTile().method_11010().method_11654((class_2769)class_2741.field_12481));
        box = box.method_996(this.getManager().getTile().method_11016());
        AtomicInteger toPlace = new AtomicInteger(amount);
        class_2338.method_29715((class_238)box).forEach(pos -> {
            if (toPlace.get() > 0) {
                class_2694 cached = new class_2694((class_4538)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (cached.method_11681().method_26207() != class_3614.field_15959) {
                        this.getManager().getLevel().method_22352(pos, drop);
                    }
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    private void setBlock(class_1937 world, class_2338 pos, PartialBlockState state) {
        world.method_8501(pos, state.getBlockState());
        class_2586 tile = world.method_8321(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().method_33133()) {
            class_2487 nbt = state.getNbt().method_10553();
            nbt.method_10569("x", pos.method_10263());
            nbt.method_10569("y", pos.method_10264());
            nbt.method_10569("z", pos.method_10260());
            tile.method_11014(nbt);
        }
    }
}

