/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import fr.frinn.custommachinery.client.RenderTypes;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.util.CycleTimer;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2694;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3614;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_765;

public class StructureRenderer {
    private final int time;
    private final long start;
    private final Function<class_2350, Map<class_2338, IIngredient<PartialBlockState>>> blocksGetter;
    private final CycleTimer timer;

    public StructureRenderer(int time, Function<class_2350, Map<class_2338, IIngredient<PartialBlockState>>> blocksGetter) {
        this.time = time;
        this.start = System.currentTimeMillis();
        this.blocksGetter = blocksGetter;
        this.timer = new CycleTimer(() -> CMConfig.get().blockTagCycleTime);
    }

    public void render(class_4587 matrix, class_4597 buffer, class_2350 direction, class_1937 world, class_2338 machinePos) {
        Map<class_2338, IIngredient<PartialBlockState>> blocks = this.blocksGetter.apply(direction);
        this.timer.onDraw();
        blocks.forEach((pos, ingredient) -> {
            matrix.method_22903();
            matrix.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
            if ((pos.method_10263() != 0 || pos.method_10264() != 0 || pos.method_10260() != 0) && ingredient != BlockIngredient.ANY) {
                PartialBlockState state = (PartialBlockState)this.timer.get(ingredient.getAll());
                class_2338 blockPos = machinePos.method_10081((class_2382)pos);
                if (state != null && state != PartialBlockState.ANY && state.getBlockState().method_26207() != class_3614.field_15959) {
                    if (world.method_8320(blockPos).method_26207() == class_3614.field_15959) {
                        this.renderTransparentBlock(state, matrix, buffer);
                    } else if (ingredient.getAll().stream().noneMatch(test -> test.test(new class_2694((class_4538)world, blockPos, false)))) {
                        this.renderNope(matrix, buffer);
                    }
                }
            }
            matrix.method_22909();
        });
    }

    private void renderTransparentBlock(PartialBlockState state, class_4587 matrix, class_4597 buffer) {
        class_4588 builder = buffer.getBuffer(RenderTypes.PHANTOM);
        matrix.method_22904((double)0.1f, (double)0.1f, (double)0.1f);
        matrix.method_22905(0.8f, 0.8f, 0.8f);
        class_1087 model = class_310.method_1551().method_1541().method_3349(state.getBlockState());
        int[] light = new int[4];
        Arrays.fill(light, class_765.method_23687((int)15, (int)15));
        if (model != class_310.method_1551().method_1554().method_4744()) {
            Arrays.stream(class_2350.values()).flatMap(direction -> model.method_4707(state.getBlockState(), direction, new Random(42L)).stream()).forEach(quad -> builder.method_22920(matrix.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444, false));
            model.method_4707(state.getBlockState(), null, new Random(42L)).forEach(quad -> builder.method_22920(matrix.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444, false));
        }
    }

    private void renderNope(class_4587 matrix, class_4597 buffer) {
        class_4588 builder = buffer.getBuffer(RenderTypes.NOPE);
        class_1087 model = class_310.method_1551().method_1554().field_5408.getOrDefault(new class_2960("custommachinery", "block/nope"), class_310.method_1551().method_1554().method_4744());
        matrix.method_22904(-5.0E-4, -5.0E-4, -5.0E-4);
        matrix.method_22905(1.001f, 1.001f, 1.001f);
        int[] light = new int[4];
        Arrays.fill(light, class_765.method_23687((int)15, (int)15));
        Arrays.stream(class_2350.values()).flatMap(direction -> model.method_4707(null, direction, new Random(42L)).stream()).forEach(quad -> builder.method_22920(matrix.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444, false));
        model.method_4707(null, null, new Random(42L)).forEach(quad -> builder.method_22920(matrix.method_23760(), quad, new float[]{1.0f, 1.0f, 1.0f, 0.8f}, 1.0f, 1.0f, 1.0f, light, class_4608.field_21444, false));
    }

    public boolean shouldRender() {
        return System.currentTimeMillis() < this.start + (long)this.time;
    }
}

