/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import fr.frinn.custommachinery.client.render.BoxRenderer;
import fr.frinn.custommachinery.client.render.StructureRenderer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.integration.config.CMConfig;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;

public class CustomMachineRenderer
implements class_827<CustomMachineTile> {
    private static final Map<class_2960, BoxRenderer> boxToRender = new HashMap<class_2960, BoxRenderer>();
    private static final Map<class_2960, StructureRenderer> blocksToRender = new HashMap<class_2960, StructureRenderer>();

    public CustomMachineRenderer(class_5614.class_5615 context) {
    }

    public void render(CustomMachineTile tile, float partialTicks, class_4587 matrix, class_4597 buffer, int combinedLight, int combinedOverlay) {
        if (tile.method_10997() == null) {
            return;
        }
        class_2960 machineId = tile.getId();
        class_2350 machineFacing = (class_2350)tile.method_11010().method_11654((class_2769)class_2741.field_12481);
        if (boxToRender.containsKey(machineId)) {
            BoxRenderer boxRenderer = boxToRender.get(machineId);
            if (boxRenderer.shouldRender()) {
                boxRenderer.render(matrix, buffer, machineFacing);
            } else {
                boxToRender.remove(machineId);
            }
        }
        if (blocksToRender.containsKey(machineId)) {
            StructureRenderer structureRenderer = blocksToRender.get(machineId);
            if (structureRenderer.shouldRender()) {
                structureRenderer.render(matrix, buffer, machineFacing, tile.method_10997(), tile.method_11016());
            } else {
                blocksToRender.remove(machineId);
            }
        }
    }

    public static void addRenderBox(class_2960 machine, class_238 box) {
        boxToRender.put(machine, new BoxRenderer(CMConfig.get().boxRenderTime, box));
    }

    public static void addRenderBlock(class_2960 machine, Function<class_2350, Map<class_2338, IIngredient<PartialBlockState>>> blocks) {
        blocksToRender.put(machine, new StructureRenderer(CMConfig.get().structureRenderTime, blocks));
    }
}

