/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.LootTableHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class LootTableIngredientWrapper
implements IJEIIngredientWrapper<class_1799> {
    private final class_2960 lootTable;

    public LootTableIngredientWrapper(class_2960 lootTable) {
        this.lootTable = lootTable;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        SlotGuiElement slotElement;
        block5: {
            block4: {
                if (!(element instanceof SlotGuiElement)) break block4;
                slotElement = (SlotGuiElement)element;
                if (element.getType() == Registration.SLOT_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        Map<class_1799, Double> table = LootTableHelper.getLootsForTable(this.lootTable).stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        ArrayList ingredients = Lists.newArrayList(table.keySet());
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(slotElement);
        if (template.map(t -> t.canAccept(ingredients, false, helper.getDummyManager())).orElse(false).booleanValue()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, element.getX() - xOffset, element.getY() - yOffset).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)ingredients)).addTooltipCallback((view, tooltips) -> {
                double chance = view.getDisplayedIngredient((IIngredientType)VanillaTypes.ITEM_STACK).map(table::get).orElse(1.0);
                if (chance != 1.0) {
                    double percentage = chance * 100.0;
                    if (percentage < (double)0.01f) {
                        tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{"<0.01"}));
                    } else {
                        BigDecimal decimal = BigDecimal.valueOf(percentage).setScale(2, RoundingMode.HALF_UP);
                        if (decimal.scale() <= 0 || decimal.signum() == 0 || decimal.stripTrailingZeros().scale() <= 0) {
                            tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{decimal.intValue()}));
                        } else {
                            tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{decimal.doubleValue()}));
                        }
                    }
                }
            });
            return true;
        }
        return false;
    }
}

