/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.wrapper;

import dev.architectury.fluid.FluidStack;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.guielement.FluidGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredientTypeWithSubtypes;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3611;

public class FluidIngredientWrapper
implements IJEIIngredientWrapper<FluidStack> {
    private final RequirementIOMode mode;
    private final IIngredient<class_3611> fluid;
    private final long amount;
    private final double chance;
    private final boolean isPerTick;
    private final class_2487 nbt;
    private final String tank;

    public FluidIngredientWrapper(RequirementIOMode mode, IIngredient<class_3611> fluid, long amount, double chance, boolean isPerTick, class_2487 nbt, String tank) {
        this.mode = mode;
        this.fluid = fluid;
        this.amount = amount;
        this.chance = chance;
        this.isPerTick = isPerTick;
        this.nbt = nbt;
        this.tank = tank;
    }

    @Override
    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        FluidGuiElement fluidElement;
        block5: {
            block4: {
                if (!(element instanceof FluidGuiElement)) break block4;
                fluidElement = (FluidGuiElement)element;
                if (element.getType() == Registration.FLUID_GUI_ELEMENT.get()) break block5;
            }
            return false;
        }
        List<FluidStack> ingredients = this.fluid.getAll().stream().map(fluid -> FluidStack.create((class_3611)fluid, (long)this.amount, (class_2487)this.nbt)).toList();
        Optional<IMachineComponentTemplate<?>> template = helper.getComponentForElement(fluidElement);
        if (fluidElement.getID().equals(this.tank) || template.map(t -> t.canAccept(ingredients, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.tank.isEmpty() || t.getId().equals(this.tank))).orElse(false).booleanValue()) {
            IRecipeSlotBuilder slot = builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset, element.getY() - yOffset).setFluidRenderer(this.amount, false, element.getWidth() - 2, element.getHeight() - 2).addTooltipCallback((view, tooltips) -> {
                if (this.isPerTick) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.fluid.pertick"));
                }
                if (this.chance == 0.0) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.chance.0").method_27692(class_124.field_1079));
                } else if (this.chance != 1.0) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.chance", new Object[]{(int)(this.chance * 100.0)}));
                }
                if (!this.tank.isEmpty() && class_310.method_1551().field_1690.field_1827) {
                    tooltips.add(new class_2588("custommachinery.jei.ingredient.fluid.specificTank").method_27692(class_124.field_1079));
                }
            });
            this.addFluidIngredients(helper.getJeiHelpers().getPlatformFluidHelper(), slot);
            return true;
        }
        return false;
    }

    public <T> void addFluidIngredients(IPlatformFluidHelper<T> helper, IRecipeSlotBuilder builder) {
        IIngredientTypeWithSubtypes fluidType = helper.getFluidIngredientType();
        List<Object> stacks = this.fluid.getAll().stream().map(fluid -> helper.create(fluid, this.amount, this.nbt)).toList();
        builder.addIngredients((IIngredientType)fluidType, stacks);
    }
}

