/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.RegisterGuiElementWidgetSupplierEvent;
import fr.frinn.custommachinery.api.integration.jei.RegisterGuiElementJEIRendererEvent;
import fr.frinn.custommachinery.client.integration.jei.element.EnergyGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.FluidGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.FuelGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.ProgressGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.SlotGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.TextGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.integration.jei.element.TextureGuiElementJeiRenderer;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.client.render.element.ButtonGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ConfigGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.DumpGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.EnergyGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.FluidGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.FuelGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.PlayerInventoryGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ProgressGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.ResetGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.SlotGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.StatusGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.TextGuiElementWidget;
import fr.frinn.custommachinery.client.render.element.TextureGuiElementWidget;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.client.screen.creator.MachineCreationScreen;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import fr.frinn.custommachinery.impl.integration.jei.GuiElementJEIRendererRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1163;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    public static void init() {
        ClientTooltipEvent.ITEM.register(ClientHandler::onItemTooltip);
        LifecycleEvent.SETUP.register(ClientHandler::clientSetup);
        RegisterGuiElementWidgetSupplierEvent.EVENT.register(ClientHandler::registerGuiElementWidgets);
        RegisterGuiElementJEIRendererEvent.EVENT.register(ClientHandler::registerGuiElementJEIRenderers);
    }

    private static void onItemTooltip(class_1799 stack, List<class_2561> lines, class_1836 flag) {
        CustomMachinery.UPGRADES.getUpgradesForItem(stack.method_7909()).forEach(upgrade -> {
            block3: {
                block2: {
                    lines.addAll(upgrade.getTooltips());
                    if (class_437.method_25441()) break block2;
                    if (!class_437.method_25442()) break block3;
                }
                upgrade.getModifiers().stream().map(RecipeModifier::getTooltip).forEach(lines::add);
            }
        });
    }

    private static void clientSetup() {
        RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{(class_2248)Registration.CUSTOM_MACHINE_BLOCK.get()});
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> RenderTypeRegistry.register((class_1921)class_1921.method_23583(), (class_2248[])new class_2248[]{block}));
        MenuRegistry.registerScreenFactory((class_3917)((class_3917)Registration.CUSTOM_MACHINE_CONTAINER.get()), CustomMachineScreen::new);
        GuiElementWidgetSupplierRegistry.init();
        if (Platform.isModLoaded((String)"jei")) {
            GuiElementJEIRendererRegistry.init();
        }
        BlockEntityRendererRegistry.register((class_2591)((class_2591)Registration.CUSTOM_MACHINE_TILE.get()), CustomMachineRenderer::new);
        ColorHandlerRegistry.registerBlockColors(ClientHandler::blockColor, (class_2248[])new class_2248[]{(class_2248)Registration.CUSTOM_MACHINE_BLOCK.get()});
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> ColorHandlerRegistry.registerBlockColors(ClientHandler::blockColor, (class_2248[])new class_2248[]{block}));
        class_1935[] class_1935Array = new class_1935[1];
        class_1935Array[0] = () -> Registration.CUSTOM_MACHINE_ITEM.get();
        ColorHandlerRegistry.registerItemColors(ClientHandler::itemColor, (class_1935[])class_1935Array);
        CustomMachinery.CUSTOM_BLOCK_MACHINES.values().forEach(block -> ColorHandlerRegistry.registerItemColors(ClientHandler::itemColor, (class_1935[])new class_1935[]{block}));
    }

    private static void registerGuiElementWidgets(RegisterGuiElementWidgetSupplierEvent event) {
        event.register((GuiElementType)((Object)Registration.ENERGY_GUI_ELEMENT.get()), EnergyGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.FLUID_GUI_ELEMENT.get()), FluidGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.PLAYER_INVENTORY_GUI_ELEMENT.get()), PlayerInventoryGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.PROGRESS_GUI_ELEMENT.get()), ProgressGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.SLOT_GUI_ELEMENT.get()), SlotGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.STATUS_GUI_ELEMENT.get()), StatusGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.TEXTURE_GUI_ELEMENT.get()), TextureGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.TEXT_GUI_ELEMENT.get()), TextGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.FUEL_GUI_ELEMENT.get()), FuelGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.RESET_GUI_ELEMENT.get()), ResetGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.DUMP_GUI_ELEMENT.get()), DumpGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.CONFIG_GUI_ELEMENT.get()), ConfigGuiElementWidget::new);
        event.register((GuiElementType)((Object)Registration.BUTTON_GUI_ELEMENT.get()), ButtonGuiElementWidget::new);
    }

    private static void registerGuiElementJEIRenderers(RegisterGuiElementJEIRendererEvent event) {
        event.register((GuiElementType)((Object)Registration.ENERGY_GUI_ELEMENT.get()), new EnergyGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.FLUID_GUI_ELEMENT.get()), new FluidGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.FUEL_GUI_ELEMENT.get()), new FuelGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.PROGRESS_GUI_ELEMENT.get()), new ProgressGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.SLOT_GUI_ELEMENT.get()), new SlotGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.TEXT_GUI_ELEMENT.get()), new TextGuiElementJeiRenderer());
        event.register((GuiElementType)((Object)Registration.TEXTURE_GUI_ELEMENT.get()), new TextureGuiElementJeiRenderer());
    }

    public static void openMachineLoadingScreen() {
        class_310.method_1551().method_1507((class_437)MachineCreationScreen.INSTANCE);
    }

    private static int blockColor(class_2680 state, class_1920 level, class_2338 pos, int tintIndex) {
        if (level == null || pos == null) {
            return 0;
        }
        switch (tintIndex) {
            case 1: {
                return level.method_23752(pos, class_1163.field_5666);
            }
            case 2: {
                return level.method_23752(pos, class_1163.field_5665);
            }
            case 3: {
                return level.method_23752(pos, class_1163.field_5664);
            }
            case 4: {
                class_2586 tile = level.method_8321(pos);
                if (!(tile instanceof CustomMachineTile)) break;
                CustomMachineTile machineTile = (CustomMachineTile)tile;
                return machineTile.getAppearance().getColor();
            }
        }
        return 0xFFFFFF;
    }

    private static int itemColor(class_1799 stack, int tintIndex) {
        class_2680 state = ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).method_9564();
        class_638 level = class_310.method_1551().field_1687;
        if (class_310.method_1551().field_1724 == null) {
            return 0;
        }
        class_2338 pos = class_310.method_1551().field_1724.method_24515();
        return class_310.method_1551().method_1505().method_1697(state, (class_1920)level, pos, tintIndex);
    }

    @NotNull
    public static CustomMachineTile getClientSideCustomMachineTile(class_2338 pos) {
        class_2586 tile;
        if (class_310.method_1551().field_1687 != null && (tile = class_310.method_1551().field_1687.method_8321(pos)) instanceof CustomMachineTile) {
            return (CustomMachineTile)tile;
        }
        throw new IllegalStateException("Trying to open a Custom Machine container without clicking on a Custom Machine block");
    }

    public static void drawSizedString(class_327 font, class_4587 matrix, String string, int x, int y, int size, float maxScale, int color) {
        float stringSize = font.method_1727(string);
        float scale = Math.min((float)size / stringSize, maxScale);
        matrix.method_22903();
        matrix.method_22905(scale, scale, 0.0f);
        font.method_1729(matrix, string, (float)x / scale, (float)y / scale, color);
        matrix.method_22909();
    }

    public static void drawCenteredString(class_327 font, class_4587 matrix, String string, int x, int y, int color) {
        int width = font.method_1727(string);
        Objects.requireNonNull(font);
        int height = 9;
        matrix.method_22903();
        matrix.method_22904((double)(-width) / 2.0, (double)(-height) / 2.0, 0.0);
        font.method_1729(matrix, string, (float)x, (float)y, color);
        matrix.method_22909();
    }

    public static void renderItemAndEffectsIntoGUI(class_4587 matrix, class_1799 stack, int x, int y) {
        boolean flag;
        matrix.method_22903();
        ClientHandler.bindTexture(class_1059.field_5275);
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrix.method_22904((double)x, (double)y, (double)(100.0f + class_310.method_1551().method_1480().field_4730));
        matrix.method_22904(8.0, 8.0, 0.0);
        matrix.method_22905(1.0f, -1.0f, 1.0f);
        matrix.method_22905(16.0f, 16.0f, 16.0f);
        class_4597.class_4598 irendertypebuffer$impl = class_310.method_1551().method_22940().method_23000();
        class_1087 model = class_310.method_1551().method_1480().method_4019(stack, null, null, 0);
        boolean bl = flag = !model.method_24304();
        if (flag) {
            class_308.method_24210();
        }
        RenderSystem.disableDepthTest();
        class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, matrix, (class_4597)irendertypebuffer$impl, 0xF000F0, class_4608.field_21444, model);
        irendertypebuffer$impl.method_22993();
        RenderSystem.enableDepthTest();
        if (flag) {
            class_308.method_24211();
        }
        RenderSystem.disableBlend();
        matrix.method_22909();
    }

    private static void draw(class_287 renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        renderer.method_22912((double)x, (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)x, (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
        renderer.method_22912((double)(x + width), (double)y, 0.0).method_1336(red, green, blue, alpha).method_1344();
        class_289.method_1348().method_1350();
    }

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y) {
        class_310 minecraft = class_310.method_1551();
        class_327 font = minecraft.field_1772;
        ClientHandler.drawHoveringText(poseStack, textLines, x, y, font);
    }

    public static void drawHoveringText(class_4587 poseStack, List<class_2561> textLines, int x, int y, class_327 font) {
        class_310 minecraft = class_310.method_1551();
        class_437 screen = minecraft.field_1755;
        if (screen == null) {
            return;
        }
        screen.method_32634(poseStack, textLines, Optional.empty(), x, y);
    }

    public static void renderSlotHighlight(class_4587 pose, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        class_332.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-2130706433);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }

    public static void renderButtonHover(class_4587 pose, int x, int y, int width, int height) {
        RenderSystem.disableDepthTest();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        class_332.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + width), (int)(y + 1), (int)class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        class_332.method_25294((class_4587)pose, (int)(x + width - 1), (int)y, (int)(x + width), (int)(y + height), (int)class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        class_332.method_25294((class_4587)pose, (int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        class_332.method_25294((class_4587)pose, (int)x, (int)y, (int)(x + 1), (int)(y + height), (int)class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableDepthTest();
    }
}

