/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.component.variant;

import com.google.common.collect.ImmutableMap;
import dev.architectury.event.Event;
import dev.architectury.event.EventFactory;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.component.variant.IComponentVariant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class RegisterComponentVariantEvent {
    public static final Event<Register> EVENT = EventFactory.createLoop((Object[])new Register[0]);
    private final Map<MachineComponentType<? extends IMachineComponent>, Map<class_2960, NamedCodec<? extends IComponentVariant>>> componentVariants = new HashMap<MachineComponentType<? extends IMachineComponent>, Map<class_2960, NamedCodec<? extends IComponentVariant>>>();

    public <C extends IMachineComponent> void register(MachineComponentType<C> type, class_2960 id, NamedCodec<? extends IComponentVariant> codec) {
        if (this.componentVariants.computeIfAbsent(type, t -> new HashMap()).containsKey(id)) {
            throw new IllegalArgumentException("Component variant " + id + " already registered for type: " + type.getId());
        }
        this.componentVariants.get(type).put(id, codec);
    }

    public Map<MachineComponentType<? extends IMachineComponent>, Map<class_2960, NamedCodec<? extends IComponentVariant>>> getComponentVariants() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.componentVariants.forEach((type, map) -> builder.put((Object)type, (Object)ImmutableMap.copyOf((Map)map)));
        return builder.build();
    }

    public static interface Register {
        public void registerComponentVariant(RegisterComponentVariantEvent var1);
    }
}

