/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.worldgen;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.DynamicDataProvider;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.infrastructure.worldgen.AllLayerPatterns;
import com.simibubi.create.infrastructure.worldgen.OreFeatureConfigEntry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraftforge.common.ForgeConfigSpec;

public class AllOreFeatureConfigEntries {
    private static final Predicate<BiomeSelectionContext> OVERWORLD_BIOMES = BiomeSelectors.foundInOverworld();
    private static final Predicate<BiomeSelectionContext> NETHER_BIOMES = BiomeSelectors.foundInTheNether();
    public static final OreFeatureConfigEntry ZINC_ORE = AllOreFeatureConfigEntries.create("zinc_ore", 12, 8.0f, -63, 70).biomeExt().predicate(OVERWORLD_BIOMES).parent().standardDatagenExt().withBlocks(Couple.create(AllBlocks.ZINC_ORE, AllBlocks.DEEPSLATE_ZINC_ORE)).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_OVERWORLD = AllOreFeatureConfigEntries.create("striated_ores_overworld", 32, 0.055555556f, -30, 70).biomeExt().predicate(OVERWORLD_BIOMES).parent().layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA).withLayerPattern(AllLayerPatterns.CINNABAR).withLayerPattern(AllLayerPatterns.MAGNETITE).withLayerPattern(AllLayerPatterns.MALACHITE).withLayerPattern(AllLayerPatterns.LIMESTONE).withLayerPattern(AllLayerPatterns.OCHRESTONE).parent();
    public static final OreFeatureConfigEntry STRIATED_ORES_NETHER = AllOreFeatureConfigEntries.create("striated_ores_nether", 32, 0.055555556f, 40, 90).biomeExt().predicate(NETHER_BIOMES).parent().layeredDatagenExt().withLayerPattern(AllLayerPatterns.SCORIA_NETHER).withLayerPattern(AllLayerPatterns.SCORCHIA_NETHER).parent();

    private static OreFeatureConfigEntry create(String name, int clusterSize, float frequency, int minHeight, int maxHeight) {
        class_2960 id = Create.asResource(name);
        OreFeatureConfigEntry configDrivenFeatureEntry = new OreFeatureConfigEntry(id, clusterSize, frequency, minHeight, maxHeight);
        return configDrivenFeatureEntry;
    }

    public static void fillConfig(ForgeConfigSpec.Builder builder, String namespace) {
        OreFeatureConfigEntry.ALL.forEach((id, entry) -> {
            if (id.method_12836().equals(namespace)) {
                builder.push(entry.getName());
                entry.addToConfig(builder);
                builder.pop();
            }
        });
    }

    public static void init() {
    }

    public static void modifyBiomes() {
        for (OreFeatureConfigEntry entry : OreFeatureConfigEntry.ALL.values()) {
            entry.biomeExt().modifyBiomes((class_2378<class_6796>)class_5458.field_35761);
        }
    }

    public static void gatherData(FabricDataGenerator generator) {
        class_5455 registryAccess = (class_5455)class_5455.field_26733.get();
        HashMap configuredFeatures = new HashMap();
        for (Map.Entry<class_2960, OreFeatureConfigEntry> entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = entry.getValue().datagenExt();
            if (datagenExt == null) continue;
            configuredFeatures.put(entry.getKey(), datagenExt.createConfiguredFeature(registryAccess));
        }
        DynamicDataProvider configuredFeatureProvider = DynamicDataProvider.create((class_2403)generator, "Create's Configured Features", registryAccess, class_2378.field_25914, configuredFeatures);
        if (configuredFeatureProvider != null) {
            generator.method_10314(configuredFeatureProvider);
        }
        HashMap<class_2960, class_6796> placedFeatures = new HashMap<class_2960, class_6796>();
        for (Map.Entry entry : OreFeatureConfigEntry.ALL.entrySet()) {
            OreFeatureConfigEntry.DatagenExtension datagenExt = ((OreFeatureConfigEntry)entry.getValue()).datagenExt();
            if (datagenExt == null) continue;
            placedFeatures.put((class_2960)entry.getKey(), datagenExt.createPlacedFeature(registryAccess));
        }
        DynamicDataProvider placedFeatureProvider = DynamicDataProvider.create((class_2403)generator, "Create's Placed Features", registryAccess, class_2378.field_35758, placedFeatures);
        if (placedFeatureProvider != null) {
            generator.method_10314(placedFeatureProvider);
        }
    }
}

