/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.simibubi.create.content.fluids.pipes.valve.FluidValveBlock;
import com.simibubi.create.content.kinetics.crank.ValveHandleBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2401;
import net.minecraft.class_2453;
import net.minecraft.class_2591;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4512;
import net.minecraft.class_6302;
import net.minecraft.class_6880;

@GameTestGroup(path="fluids")
public class TestFluids {
    @class_6302(method_35936="hose_pulley_transfer", method_35932=400)
    public static void hosePulleyTransfer(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(7, 7, 5);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(15);
            class_2338 filledLowerCorner = new class_2338(2, 3, 2);
            class_2338 filledUpperCorner = new class_2338(4, 5, 4);
            class_2338.method_10097((class_2338)filledLowerCorner, (class_2338)filledUpperCorner).forEach(pos -> helper.method_35972(class_2246.field_10382, (class_2338)pos));
            class_2338 emptiedLowerCorner = new class_2338(8, 3, 2);
            class_2338 emptiedUpperCorner = new class_2338(10, 5, 4);
            class_2338.method_10097((class_2338)emptiedLowerCorner, (class_2338)emptiedUpperCorner).forEach(pos -> helper.method_35972(class_2246.field_10124, (class_2338)pos));
            class_2338 pulleyPos = new class_2338(4, 7, 3);
            Storage<FluidVariant> storage = helper.fluidStorageAt(pulleyPos);
            if (storage instanceof HosePulleyFluidHandler) {
                HosePulleyFluidHandler hose = (HosePulleyFluidHandler)storage;
                SmartFluidTank internalTank = hose.getInternalTank();
                if (!internalTank.isEmpty()) {
                    helper.method_35995("Pulley not empty");
                }
            } else {
                helper.method_35995("Not a pulley");
            }
        });
    }

    @class_6302(method_35936="in_world_pumping_out")
    public static void inWorldPumpingOut(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(4, 3, 3);
        class_2338 basin = new class_2338(5, 2, 2);
        class_2338 output = new class_2338(2, 2, 2);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.method_35972(class_2246.field_10382, output);
            helper.assertTankEmpty(basin);
        });
    }

    @class_6302(method_35936="in_world_pumping_in")
    public static void inWorldPumpingIn(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(4, 3, 3);
        class_2338 basin = new class_2338(5, 2, 2);
        class_2338 water = new class_2338(2, 2, 2);
        FluidStack expectedResult = new FluidStack((class_3611)class_3612.field_15910, 81000L);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.method_35972(class_2246.field_10124, water);
            helper.assertFluidPresent(expectedResult, basin);
        });
    }

    @class_6302(method_35936="steam_engine")
    public static void steamEngine(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(4, 3, 3);
        helper.method_36039(lever);
        class_2338 stressometer = new class_2338(5, 2, 5);
        class_2338 speedometer = new class_2338(4, 2, 5);
        helper.method_36018(() -> {
            StressGaugeBlockEntity stress = (StressGaugeBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
            SpeedGaugeBlockEntity speed = (SpeedGaugeBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
            float capacity = stress.getNetworkCapacity();
            helper.assertCloseEnoughTo(capacity, 2048.0);
            float rotationSpeed = class_3532.method_15379((float)speed.getSpeed());
            helper.assertCloseEnoughTo(rotationSpeed, 16.0);
        });
    }

    @class_6302(method_35936="3_pipe_combine", method_35932=400)
    public static void threePipeCombine(CreateGameTestHelper helper) {
        class_2338 tank1Pos = new class_2338(5, 2, 1);
        class_2338 tank2Pos = tank1Pos.method_10072();
        class_2338 tank3Pos = tank2Pos.method_10072();
        long initialContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos);
        class_2338 pumpPos = new class_2338(2, 2, 2);
        helper.flipBlock(pumpPos);
        helper.method_36018(() -> {
            helper.assertSecondsPassed(13);
            helper.assertTanksEmpty(tank1Pos, tank2Pos, tank3Pos);
            class_2338 outputTankPos = new class_2338(1, 2, 2);
            long moved = helper.getFluidInTanks(outputTankPos);
            if (moved != initialContents) {
                helper.method_35995("Wrong amount of fluid amount. expected [%s], got [%s]".formatted(initialContents, moved));
            }
        });
    }

    @class_6302(method_35936="3_pipe_split", method_35932=200)
    public static void threePipeSplit(CreateGameTestHelper helper) {
        class_2338 pumpPos = new class_2338(2, 2, 2);
        class_2338 tank1Pos = new class_2338(5, 2, 1);
        class_2338 tank2Pos = tank1Pos.method_10072();
        class_2338 tank3Pos = tank2Pos.method_10072();
        class_2338 outputTankPos = new class_2338(1, 2, 2);
        long totalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos, outputTankPos);
        helper.flipBlock(pumpPos);
        helper.method_36018(() -> {
            long newTotalContents;
            helper.assertSecondsPassed(7);
            FluidStack contents = helper.getTankContents(outputTankPos);
            if (!contents.isEmpty()) {
                helper.method_35995("Tank not empty: " + contents.getAmount());
            }
            if ((newTotalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos)) != totalContents) {
                helper.method_35995("Wrong total fluid amount. expected [%s], got [%s]".formatted(totalContents, newTotalContents));
            }
        });
    }

    @class_6302(method_35936="large_waterwheel", method_35932=200)
    public static void largeWaterwheel(CreateGameTestHelper helper) {
        class_2338 wheel = new class_2338(4, 3, 2);
        class_2338 leftEnd = new class_2338(6, 2, 2);
        class_2338 rightEnd = new class_2338(2, 2, 2);
        List<class_2338> edges = List.of(new class_2338(4, 5, 1), new class_2338(4, 5, 3));
        class_2338 openLever = new class_2338(3, 8, 1);
        class_2338 leftLever = new class_2338(5, 7, 1);
        TestFluids.waterwheel(helper, wheel, 4.0f, 512.0f, leftEnd, rightEnd, edges, openLever, leftLever);
    }

    @class_6302(method_35936="small_waterwheel", method_35932=200)
    public static void smallWaterwheel(CreateGameTestHelper helper) {
        class_2338 wheel = new class_2338(3, 2, 2);
        class_2338 leftEnd = new class_2338(4, 2, 2);
        class_2338 rightEnd = new class_2338(2, 2, 2);
        List<class_2338> edges = List.of(new class_2338(3, 3, 1), new class_2338(3, 3, 3));
        class_2338 openLever = new class_2338(2, 6, 1);
        class_2338 leftLever = new class_2338(4, 5, 1);
        TestFluids.waterwheel(helper, wheel, 8.0f, 256.0f, leftEnd, rightEnd, edges, openLever, leftLever);
    }

    private static void waterwheel(CreateGameTestHelper helper, class_2338 wheel, float expectedRpm, float expectedSU, class_2338 leftEnd, class_2338 rightEnd, List<class_2338> edges, class_2338 openLever, class_2338 leftLever) {
        class_2338 speedometer = wheel.method_10095();
        class_2338 stressometer = wheel.method_10072();
        helper.method_36039(openLever);
        helper.method_36018(() -> {
            edges.forEach(pos -> helper.method_36012(class_2246.field_10382, (class_2338)pos));
            helper.method_35972(class_2246.field_10382, rightEnd);
            if (!((Boolean)helper.method_35980(leftLever).method_11654((class_2769)class_2401.field_11265)).booleanValue()) {
                helper.method_35972(class_2246.field_10382, leftEnd);
                helper.assertSpeedometerSpeed(speedometer, 0.0f);
                helper.assertStressometerCapacity(stressometer, 0.0f);
                helper.powerLever(leftLever);
                helper.method_35995("Entering step 2");
            } else {
                helper.method_36012(class_2246.field_10382, leftEnd);
                helper.assertSpeedometerSpeed(speedometer, expectedRpm);
                helper.assertStressometerCapacity(stressometer, expectedSU);
            }
        });
    }

    @class_6302(method_35936="waterwheel_materials", method_35932=300)
    public static void waterwheelMaterials(CreateGameTestHelper helper) {
        List planks = class_2378.field_11146.method_40260(class_3481.field_15471).method_40239().map(class_6880::comp_349).map(class_1935::method_8389).collect(Collectors.toCollection(ArrayList::new));
        List<class_2338> chests = List.of(new class_2338(6, 4, 2), new class_2338(6, 4, 3));
        List<class_2338> deployers = chests.stream().map(pos -> pos.method_10087(2)).toList();
        helper.method_36003(3L, () -> chests.forEach(chest -> planks.forEach(plank -> TransferUtil.insertItem(helper.itemStorageAt((class_2338)chest), (class_1799)new class_1799((class_1935)plank)))));
        class_2338 smallWheel = new class_2338(4, 2, 2);
        class_2338 largeWheel = new class_2338(3, 3, 3);
        class_2338 lever = new class_2338(5, 3, 1);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            class_1792 plank = (class_1792)planks.get(0);
            if (!(plank instanceof class_1747)) {
                throw new class_4512(class_2378.field_11142.method_10221((Object)plank) + " is not a BlockItem");
            }
            class_1747 blockItem = (class_1747)plank;
            class_2248 block = blockItem.method_7711();
            WaterWheelBlockEntity smallWheelBe = (WaterWheelBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.WATER_WHEEL.get(), smallWheel);
            if (!smallWheelBe.material.method_27852(block)) {
                helper.method_35995("Small waterwheel has not consumed " + class_2378.field_11142.method_10221((Object)plank));
            }
            WaterWheelBlockEntity largeWheelBe = (WaterWheelBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.LARGE_WATER_WHEEL.get(), largeWheel);
            if (!largeWheelBe.material.method_27852(block)) {
                helper.method_35995("Large waterwheel has not consumed " + class_2378.field_11142.method_10221((Object)plank));
            }
            planks.remove(0);
            deployers.forEach(pos -> TransferUtil.clearStorage(helper.itemStorageAt((class_2338)pos)));
            if (!planks.isEmpty()) {
                helper.method_35995("Not all planks have been consumed");
            }
        });
    }

    @class_6302(method_35936="smart_observer_pipes")
    public static void smartObserverPipes(CreateGameTestHelper helper) {
        class_2338 lever = new class_2338(3, 3, 1);
        class_2338 output = new class_2338(3, 4, 4);
        class_2338 tankOutput = new class_2338(1, 2, 4);
        FluidStack expected = new FluidStack((class_3611)class_3612.field_15910, 162000L);
        helper.method_36039(lever);
        helper.method_36018(() -> {
            helper.assertFluidPresent(expected, tankOutput);
            helper.method_35972(class_2246.field_10201, output);
        });
    }

    @class_6302(method_35936="threshold_switch", method_35932=400)
    public static void thresholdSwitch(CreateGameTestHelper helper) {
        class_2338 leftHandle = new class_2338(4, 2, 4);
        class_2338 leftValve = new class_2338(4, 2, 3);
        class_2338 leftTank = new class_2338(5, 2, 3);
        class_2338 rightHandle = new class_2338(2, 2, 4);
        class_2338 rightValve = new class_2338(2, 2, 3);
        class_2338 rightTank = new class_2338(1, 2, 3);
        class_2338 drainHandle = new class_2338(3, 3, 2);
        class_2338 drainValve = new class_2338(3, 3, 1);
        class_2338 lamp = new class_2338(1, 3, 1);
        class_2338 tank = new class_2338(2, 2, 1);
        helper.method_36018(() -> {
            if (!((Boolean)helper.method_35980(leftValve).method_11654((class_2769)FluidValveBlock.ENABLED)).booleanValue()) {
                ((ValveHandleBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.VALVE_HANDLE.get(), leftHandle)).activate(false);
                helper.method_35995("Entering step 2");
            } else if (!((Boolean)helper.method_35980(rightValve).method_11654((class_2769)FluidValveBlock.ENABLED)).booleanValue()) {
                helper.assertFluidPresent(FluidStack.EMPTY, leftTank);
                helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
                ((ValveHandleBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.VALVE_HANDLE.get(), rightHandle)).activate(false);
                helper.method_35995("Entering step 3");
            } else if (!((Boolean)helper.method_35980(drainValve).method_11654((class_2769)FluidValveBlock.ENABLED)).booleanValue()) {
                helper.assertFluidPresent(FluidStack.EMPTY, rightTank);
                helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(true));
                ((ValveHandleBlockEntity)helper.getBlockEntity((class_2591)AllBlockEntityTypes.VALVE_HANDLE.get(), drainHandle)).activate(false);
                helper.method_35995("Entering step 4");
            } else {
                helper.assertTankEmpty(tank);
                helper.method_35987(lamp, (class_2769)class_2453.field_11413, Boolean.valueOf(false));
            }
        });
    }
}

