/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.client.SchematicAndQuillHandler;
import com.simibubi.create.foundation.utility.Components;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public class CreateTestCommand {
    private static final Path gametests = FabricLoader.getInstance().getGameDir().getParent().resolve("src/main/resources/data/create/structures/gametest").toAbsolutePath();

    public static ArgumentBuilder<class_2168, ?> register() {
        return class_2170.method_9247((String)"test").then(class_2170.method_9247((String)"export").then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).suggests(CreateTestCommand::getSuggestions).executes(ctx -> CreateTestCommand.handleExport((class_2168)ctx.getSource(), ((class_2168)ctx.getSource()).method_9225(), StringArgumentType.getString((CommandContext)ctx, (String)"path")))));
    }

    private static int handleExport(class_2168 source, class_3218 level, String path) {
        SchematicAndQuillHandler handler = CreateClient.SCHEMATIC_AND_QUILL_HANDLER;
        if (handler.firstPos == null || handler.secondPos == null) {
            source.method_9213((class_2561)Components.literal("You must select an area with the Schematic and Quill first."));
            return 0;
        }
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(gametests, path, true, (class_1937)level, handler.firstPos, handler.secondPos);
        if (result == null) {
            source.method_9213((class_2561)Components.literal("Failed to export, check logs").method_27692(class_124.field_1061));
        } else {
            CreateTestCommand.sendSuccess(source, "Successfully exported test!", class_124.field_1060);
            CreateTestCommand.sendSuccess(source, "Overwritten: " + result.overwritten(), class_124.field_1075);
            CreateTestCommand.sendSuccess(source, "File: " + result.file(), class_124.field_1080);
        }
        return 0;
    }

    private static void sendSuccess(class_2168 source, String text, class_124 color) {
        source.method_9226((class_2561)Components.literal(text).method_27692(color), true);
    }

    private static CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        String path = builder.getRemaining();
        if (!path.contains("/") || path.contains("..")) {
            return CreateTestCommand.findInDir(gametests, builder);
        }
        int lastSlash = path.lastIndexOf("/");
        Path subDir = gametests.resolve(path.substring(0, lastSlash));
        if (Files.exists(subDir, new LinkOption[0])) {
            CreateTestCommand.findInDir(subDir, builder);
        }
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> findInDir(Path dir, SuggestionsBuilder builder) {
        try (Stream<Path> paths = Files.list(dir);){
            paths.filter(p -> Files.isDirectory(p, new LinkOption[0]) || p.toString().endsWith(".nbt")).forEach(path -> {
                Object file = path.toString().replaceAll("\\\\", "/").substring(gametests.toString().length() + 1);
                if (Files.isDirectory(path, new LinkOption[0])) {
                    file = (String)file + "/";
                }
                builder.suggest((String)file);
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.buildFuture();
    }
}

