/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.Create;
import com.tterrag.registrate.fabric.LanguageProvider;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import net.minecraft.class_2960;
import org.apache.commons.lang3.StringUtils;

public class TagLangGen {
    public static void datagen() {
        Create.REGISTRATE.addDataGenerator(ProviderType.LANG, TagLangGen::genItemTagLang);
    }

    private static void genItemTagLang(RegistrateLangProvider prov) {
        TagLangHelper common = new TagLangHelper("c", (LanguageProvider)prov);
        common.subDir("armors").put("boots", "Boots").put("chestplates", "Chestplates").put("helmets", "Helmets");
        common.subDir("dough").autoRoot().auto("wheat");
        common.subDir("flour").autoRoot().auto("wheat");
        common.subDir("ingots").auto("brass").auto("zinc");
        common.subDir("nuggets").auto("brass").auto("zinc");
        common.subDir("ores").auto("zinc");
        common.subDir("plates").auto("brass").auto("obsidian");
        common.subDir("raw_materials").auto("zinc");
        common.subDir("storage_blocks").auto("andesite_alloy").auto("brass").auto("raw_zinc").auto("zinc");
        common.auto("stripped_logs");
        common.auto("stripped_wood");
        TagLangHelper create = new TagLangHelper("create", (LanguageProvider)prov);
        create.subDir("blaze_burner_fuel").plural("regular").plural("special");
        create.plural("casing");
        create.put("contraption_controlled", "Actors");
        create.auto("create_ingots");
        create.auto("crushed_raw_materials");
        create.plural("deployable_drink");
        create.auto("modded_stripped_logs");
        create.auto("modded_stripped_wood");
        create.auto("pressurized_air_sources");
        create.auto("sandpaper");
        create.auto("seats");
        create.auto("sleepers");
        create.subDir("stone_types").ignoreDir("andesite").ignoreDir("asurine").ignoreDir("calcite").ignoreDir("crimsite").ignoreDir("deepslate").ignoreDir("diorite").ignoreDir("dripstone").ignoreDir("granite").ignoreDir("limestone").ignoreDir("ochrum").ignoreDir("scorchia").ignoreDir("scoria").ignoreDir("tuff").ignoreDir("veridium");
        create.auto("toolboxes");
        create.auto("valve_handles");
        create.auto("vanilla_stripped_logs");
        create.auto("vanilla_stripped_wood");
    }

    public static String key(class_2960 tagId) {
        String namespace = tagId.method_12836();
        String path = tagId.method_12832().replace('/', '.');
        return "tag." + namespace + "." + path;
    }

    public static String translate(class_2960 tagId) {
        String path = tagId.method_12832();
        String[] split = path.split("/");
        switch (split.length) {
            case 1: {
                return TagLangGen.toSentence(split);
            }
            case 2: {
                String[] switched = new String[]{split[1], split[0]};
                return TagLangGen.toSentence(switched);
            }
        }
        throw new IllegalArgumentException("Tags with >1 subdirectory (" + tagId + ") cannot be automatically translated");
    }

    public static String toSentence(String[] segments) {
        StringBuilder sentence = new StringBuilder();
        for (String segment : segments) {
            String[] split;
            for (String word : split = segment.split("_")) {
                String capitalized = StringUtils.capitalize((String)word);
                sentence.append(capitalized).append(' ');
            }
        }
        return sentence.toString().trim();
    }

    public record TagLangHelper(String namespace, LanguageProvider prov) {
        public TagLangHelper auto(String path) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            String name = TagLangGen.translate(id);
            this.prov.add(key, name);
            return this;
        }

        public TagLangHelper put(String path, String translated) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            this.prov.add(key, translated);
            return this;
        }

        public TagLangHelper plural(String path) {
            class_2960 id = new class_2960(this.namespace, path);
            String key = TagLangGen.key(id);
            String name = TagLangGen.translate(id) + "s";
            this.prov.add(key, name);
            return this;
        }

        public SubDirHelper subDir(String dir) {
            return new SubDirHelper(this, dir);
        }
    }

    public record SubDirHelper(TagLangHelper parent, String dir) {
        public SubDirHelper put(String path, String translated) {
            class_2960 id = this.tagId(path);
            this.parent.prov.add(TagLangGen.key(id), translated);
            return this;
        }

        public SubDirHelper auto(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)));
        }

        public SubDirHelper ignoreDir(String path) {
            class_2960 id = new class_2960(this.parent.namespace, path);
            return this.put(path, TagLangGen.translate(id));
        }

        public SubDirHelper plural(String path) {
            return this.put(path, TagLangGen.translate(this.tagId(path)) + "s");
        }

        public SubDirHelper autoRoot() {
            class_2960 id = new class_2960(this.parent.namespace, this.dir);
            this.parent.prov.add(TagLangGen.key(id), TagLangGen.translate(id));
            return this;
        }

        public class_2960 tagId(String path) {
            return new class_2960(this.parent.namespace, this.dir + "/" + path);
        }
    }
}

