/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.simibubi.create.Create;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_2403;
import net.minecraft.class_2405;
import net.minecraft.class_2408;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class DynamicDataProvider<T>
implements class_2405 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2403 generator;
    private final String name;
    private final class_5455 registryAccess;
    private final class_5455.class_5456<T> registryData;
    private final Map<class_2960, T> values;

    public DynamicDataProvider(class_2403 generator, String name, class_5455 registryAccess, class_5455.class_5456<T> registryData, Map<class_2960, T> values) {
        this.generator = generator;
        this.name = name;
        this.registryAccess = registryAccess;
        this.registryData = registryData;
        this.values = values;
    }

    @Nullable
    public static <T> DynamicDataProvider<T> create(class_2403 generator, String name, class_5455 registryAccess, class_5321<? extends class_2378<T>> registryKey, Map<class_2960, T> values) {
        class_5455.class_5456 registryData = (class_5455.class_5456)class_5455.field_25919.get(registryKey);
        if (registryData == null) {
            return null;
        }
        return new DynamicDataProvider<T>(generator, name, registryAccess, registryData, values);
    }

    public void method_10319(class_2408 cache) throws IOException {
        Path path = this.generator.method_10313();
        class_6903 ops = class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)this.registryAccess);
        this.dumpValues(path, cache, (DynamicOps<JsonElement>)ops, (class_5321<? extends class_2378<T>>)this.registryData.comp_293(), this.values, (Encoder<T>)this.registryData.comp_294());
    }

    private void dumpValues(Path rootPath, class_2408 cache, DynamicOps<JsonElement> ops, class_5321<? extends class_2378<T>> registryKey, Map<class_2960, T> values, Encoder<T> encoder) {
        for (Map.Entry<class_2960, T> entry : values.entrySet()) {
            Path path = this.createPath(rootPath, registryKey.method_29177(), entry.getKey());
            this.dumpValue(path, cache, ops, encoder, entry.getValue());
        }
    }

    private void dumpValue(Path path, class_2408 cache, DynamicOps<JsonElement> ops, Encoder<T> encoder, T value) {
        try {
            Optional optional = encoder.encodeStart(ops, value).resultOrPartial(message -> Create.LOGGER.error("Couldn't serialize element {}: {}", (Object)path, message));
            if (optional.isPresent()) {
                class_2405.method_10320((Gson)GSON, (class_2408)cache, (JsonElement)((JsonElement)optional.get()), (Path)path);
            }
        }
        catch (IOException e) {
            Create.LOGGER.error("Couldn't save element {}", (Object)path, (Object)e);
        }
    }

    private Path createPath(Path path, class_2960 registry, class_2960 value) {
        return path.resolve("data").resolve(value.method_12836()).resolve(registry.method_12832()).resolve(value.method_12832() + ".json");
    }

    public String method_10321() {
        return this.name;
    }
}

