/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.chassis.LinearChassisBlock;
import com.simibubi.create.content.contraptions.chassis.RadialChassisBlock;
import com.simibubi.create.content.contraptions.mounted.CartAssembleRailType;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.data.AssetLookup;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateGen {
    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> axisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.axisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> directionalBlockProvider(boolean customItem) {
        return (c, p) -> p.directionalBlock((class_2248)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> directionalBlockProviderIgnoresWaterlogged(boolean customItem) {
        return (c, p) -> BlockStateGen.directionalBlockIgnoresWaterlogged(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalBlockProvider(boolean customItem) {
        return (c, p) -> p.horizontalBlock((class_2248)c.get(), BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalAxisBlockProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalAxisBlock(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> simpleCubeAll(String path) {
        return (c, p) -> p.simpleBlock((class_2248)c.get(), (ModelFile)p.models().cubeAll(c.getName(), p.modLoc("block/" + path)));
    }

    public static <T extends DirectionalAxisKineticBlock> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> directionalAxisBlockProvider() {
        return (c, p) -> BlockStateGen.directionalAxisBlock(c, p, ($, vertical) -> p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/" + (vertical != false ? "vertical" : "horizontal"))));
    }

    public static <T extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, T>, RegistrateBlockstateProvider> horizontalWheelProvider(boolean customItem) {
        return (c, p) -> BlockStateGen.horizontalWheel(c, p, BlockStateGen.getBlockModel(customItem, c, p));
    }

    private static <T extends class_2248> Function<class_2680, ModelFile> getBlockModel(boolean customItem, DataGenContext<class_2248, T> c, RegistrateBlockstateProvider p) {
        return $ -> customItem ? AssetLookup.partialBaseModel(c, p, new String[0]) : AssetLookup.standardModel(c, p);
    }

    public static <T extends class_2248> void directionalBlockIgnoresWaterlogged(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc) {
        prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStatesExcept(state -> {
            class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationX(dir == class_2350.field_11033 ? 180 : (dir.method_10166().method_10179() ? 90 : 0)).rotationY(dir.method_10166().method_10178() ? 0 : ((int)dir.method_10144() + 180) % 360).build();
        }, new class_2769[]{class_2741.field_12508});
    }

    public static <T extends class_2248> void axisBlock(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc) {
        BlockStateGen.axisBlock(ctx, prov, modelFunc, false);
    }

    public static <T extends class_2248> void axisBlock(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc, boolean uvLock) {
        prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStatesExcept(state -> {
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).uvLock(uvLock).rotationX(axis == class_2350.class_2351.field_11052 ? 0 : 90).rotationY(axis == class_2350.class_2351.field_11048 ? 90 : (axis == class_2350.class_2351.field_11051 ? 180 : 0)).build();
        }, new class_2769[]{class_2741.field_12508});
    }

    public static <T extends class_2248> void simpleBlock(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc) {
        prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).build(), new class_2769[]{class_2741.field_12508});
    }

    public static <T extends class_2248> void horizontalAxisBlock(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc) {
        prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            class_2350.class_2351 axis = (class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12529);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationY(axis == class_2350.class_2351.field_11048 ? 90 : 0).build();
        });
    }

    public static <T extends DirectionalAxisKineticBlock> void directionalAxisBlock(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, BiFunction<class_2680, Boolean, ModelFile> modelFunc) {
        prov.getVariantBuilder((class_2248)ctx.getEntry()).forAllStates(state -> {
            int xRot;
            boolean vertical;
            boolean alongFirst = (Boolean)state.method_11654((class_2769)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE);
            class_2350 direction = (class_2350)state.method_11654((class_2769)DirectionalAxisKineticBlock.FACING);
            boolean bl = direction.method_10166().method_10179() && direction.method_10166() == class_2350.class_2351.field_11048 == alongFirst ? true : (vertical = false);
            int n = direction == class_2350.field_11033 ? 270 : (xRot = direction == class_2350.field_11036 ? 90 : 0);
            int yRot = direction.method_10166().method_10178() ? (alongFirst ? 0 : 90) : (int)direction.method_10144();
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state, vertical)).rotationX(xRot).rotationY(yRot).build();
        });
    }

    public static <T extends class_2248> void horizontalWheel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, Function<class_2680, ModelFile> modelFunc) {
        prov.getVariantBuilder((class_2248)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((class_2680)state)).rotationX(90).rotationY(((int)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10144() + 180) % 360).build());
    }

    public static <T extends class_2248> void cubeAll(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir) {
        BlockStateGen.cubeAll(ctx, prov, textureSubDir, ctx.getName());
    }

    public static <T extends class_2248> void cubeAll(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, String textureSubDir, String name) {
        String texturePath = "block/" + textureSubDir + name;
        prov.simpleBlock((class_2248)ctx.get(), (ModelFile)prov.models().cubeAll(ctx.getName(), prov.modLoc(texturePath)));
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, CartAssemblerBlock>, RegistrateBlockstateProvider> cartAssembler() {
        return (c, p) -> p.getVariantBuilder((class_2248)c.get()).forAllStates(state -> {
            int yRotation;
            CartAssembleRailType type = (CartAssembleRailType)((Object)((Object)((Object)state.method_11654(CartAssemblerBlock.RAIL_TYPE))));
            Boolean powered = (Boolean)state.method_11654((class_2769)CartAssemblerBlock.POWERED);
            Boolean backwards = (Boolean)state.method_11654((class_2769)CartAssemblerBlock.BACKWARDS);
            class_2768 shape = (class_2768)state.method_11654(CartAssemblerBlock.RAIL_SHAPE);
            int n = yRotation = shape == class_2768.field_12674 ? 270 : 0;
            if (backwards.booleanValue()) {
                yRotation += 180;
            }
            return ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block_" + type.method_15434() + (powered != false ? "_powered" : "")))).rotationY(yRotation % 360).build();
        });
    }

    public static NonNullBiConsumer<DataGenContext<class_2248, BlazeBurnerBlock>, RegistrateBlockstateProvider> blazeHeater() {
        return (c, p) -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.modLoc("block/" + c.getName() + "/block"))).build();
    }

    public static <B extends LinearChassisBlock> NonNullBiConsumer<DataGenContext<class_2248, B>, RegistrateBlockstateProvider> linearChassis() {
        return (c, p) -> {
            class_2960 side = p.modLoc("block/" + c.getName() + "_side");
            class_2960 top = p.modLoc("block/linear_chassis_end");
            class_2960 top_sticky = p.modLoc("block/linear_chassis_end_sticky");
            Vector<ModelBuilder> models = new Vector<ModelBuilder>(4);
            for (boolean isTopSticky : Iterate.trueAndFalse) {
                for (boolean isBottomSticky : Iterate.trueAndFalse) {
                    models.add(((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName() + (isTopSticky ? "_top" : "") + (isBottomSticky ? "_bottom" : ""), "block/cube_bottom_top")).texture("side", side)).texture("bottom", isBottomSticky ? top_sticky : top)).texture("top", isTopSticky ? top_sticky : top));
                }
            }
            BiFunction<Boolean, Boolean, ModelFile> modelFunc = (t, b) -> (ModelFile)models.get((t != false ? 0 : 2) + (b != false ? 0 : 1));
            BlockStateGen.axisBlock(c, p, state -> (ModelFile)modelFunc.apply((Boolean)state.method_11654((class_2769)LinearChassisBlock.STICKY_TOP), (Boolean)state.method_11654((class_2769)LinearChassisBlock.STICKY_BOTTOM)));
        };
    }

    public static <B extends RadialChassisBlock> NonNullBiConsumer<DataGenContext<class_2248, B>, RegistrateBlockstateProvider> radialChassis() {
        return (c, p) -> {
            String suffix;
            String path = "block/" + c.getName();
            class_2960 side = p.modLoc(path + "_side");
            class_2960 side_sticky = p.modLoc(path + "_side_sticky");
            String templateModelPath = "block/radial_chassis";
            ModelFile.ExistingModelFile base = p.models().getExistingFile(p.modLoc(templateModelPath + "/base"));
            Vector<ModelBuilder> faces = new Vector<ModelBuilder>(3);
            Vector<ModelBuilder> stickyFaces = new Vector<ModelBuilder>(3);
            for (class_2350.class_2351 axis : Iterate.axes) {
                suffix = "side_" + axis.method_15434();
                faces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix, p.modLoc(templateModelPath + "/" + suffix))).texture("side", side));
            }
            for (class_2350.class_2351 axis : Iterate.axes) {
                suffix = "side_" + axis.method_15434();
                stickyFaces.add(((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "_" + suffix + "_sticky", p.modLoc(templateModelPath + "/" + suffix))).texture("side", side_sticky));
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            class_2680 propertyGetter = (class_2680)((RadialChassisBlock)c.get()).method_9564().method_11657((class_2769)RadialChassisBlock.field_11459, (Comparable)class_2350.class_2351.field_11052);
            for (class_2350.class_2351 class_23512 : Iterate.axes) {
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)base).rotationX(class_23512 != class_2350.class_2351.field_11052 ? 90 : 0).rotationY(class_23512 != class_2350.class_2351.field_11048 ? 0 : 90).addModel()).condition((class_2769)RadialChassisBlock.field_11459, (Comparable[])new class_2350.class_2351[]{class_23512}).end();
            }
            for (class_2350.class_2351 class_23513 : Iterate.horizontalDirections) {
                for (boolean sticky : Iterate.trueAndFalse) {
                    for (class_2350.class_2351 axis : Iterate.axes) {
                        int horizontalAngle = (int)class_23513.method_10144();
                        int index = axis.ordinal();
                        int xRot = 0;
                        int yRot = 0;
                        if (axis == class_2350.class_2351.field_11048) {
                            xRot = -horizontalAngle + 180;
                        }
                        if (axis == class_2350.class_2351.field_11052) {
                            yRot = horizontalAngle;
                        }
                        if (axis == class_2350.class_2351.field_11051) {
                            yRot = -horizontalAngle + 270;
                            if (class_23513.method_10166() == class_2350.class_2351.field_11051) {
                                index = 0;
                                xRot = horizontalAngle + 180;
                                yRot = 90;
                            }
                        }
                        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)(sticky ? stickyFaces : faces).get(index)).rotationX((xRot + 360) % 360).rotationY((yRot + 360) % 360).addModel()).condition((class_2769)RadialChassisBlock.field_11459, (Comparable[])new class_2350.class_2351[]{axis}).condition((class_2769)((RadialChassisBlock)c.get()).getGlueableSide(propertyGetter, (class_2350)class_23513), (Comparable[])new Boolean[]{sticky}).end();
                    }
                }
            }
        };
    }

    public static <P extends class_2248> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> naturalStoneTypeBlock(String type) {
        return (c, p) -> {
            ConfiguredModel[] variants = new ConfiguredModel[4];
            for (int i = 0; i < variants.length; ++i) {
                variants[i] = ConfiguredModel.builder().modelFile((ModelFile)p.models().cubeAll(type + "_natural_" + i, p.modLoc("block/palettes/stone_types/natural/" + type + "_" + i))).buildLast();
            }
            p.getVariantBuilder((class_2248)c.get()).partialState().setModels(variants);
        };
    }

    public static <P extends EncasedPipeBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> encasedPipe() {
        return (c, p) -> {
            ModelFile open = AssetLookup.partialBaseModel(c, p, "open");
            ModelFile flat = AssetLookup.partialBaseModel(c, p, "flat");
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            for (boolean flatPass : Iterate.trueAndFalse) {
                for (class_2350 d : Iterate.directions) {
                    int verticalAngle = d == class_2350.field_11036 ? 90 : (d == class_2350.field_11033 ? -90 : 0);
                    ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(flatPass ? flat : open).rotationX(verticalAngle).rotationY((int)(d.method_10144() + (float)(d.method_10166().method_10178() ? 90 : 0)) % 360).addModel()).condition((class_2769)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(d), (Comparable[])new Boolean[]{!flatPass}).end();
                }
            }
        };
    }

    public static <P extends class_2533> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> uvLockedTrapdoorBlock(P block, ModelFile bottom, ModelFile top, ModelFile open) {
        return (c, p) -> p.getVariantBuilder((class_2248)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((class_2350)state.method_11654((class_2769)class_2533.field_11177)).method_10144() + 180;
            boolean isOpen = (Boolean)state.method_11654((class_2769)class_2533.field_11631);
            if (!isOpen) {
                yRot = 0;
            }
            return ConfiguredModel.builder().modelFile(isOpen ? open : (state.method_11654((class_2769)class_2533.field_11625) == class_2760.field_12619 ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360).uvLock(!isOpen).build();
        }, new class_2769[]{class_2533.field_11629, class_2533.field_11626});
    }

    public static <P extends WhistleExtenderBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> whistleExtender() {
        return (c, p) -> {
            BlockModelProvider models = p.models();
            String basePath = "block/steam_whistle/extension/";
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            for (WhistleBlock.WhistleSize size : WhistleBlock.WhistleSize.values()) {
                String basePathSize = basePath + size.method_15434() + "_";
                ModelFile.ExistingModelFile topRim = models.getExistingFile(Create.asResource(basePathSize + "top_rim"));
                ModelFile.ExistingModelFile single = models.getExistingFile(Create.asResource(basePathSize + "single"));
                ModelFile.ExistingModelFile double_ = models.getExistingFile(Create.asResource(basePathSize + "double"));
                ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)topRim).addModel()).condition(WhistleExtenderBlock.SIZE, (Comparable[])new WhistleBlock.WhistleSize[]{size}).condition(WhistleExtenderBlock.SHAPE, (Comparable[])new WhistleExtenderBlock.WhistleExtenderShape[]{WhistleExtenderBlock.WhistleExtenderShape.DOUBLE}).end().part().modelFile((ModelFile)single).addModel()).condition(WhistleExtenderBlock.SIZE, (Comparable[])new WhistleBlock.WhistleSize[]{size}).condition(WhistleExtenderBlock.SHAPE, (Comparable[])new WhistleExtenderBlock.WhistleExtenderShape[]{WhistleExtenderBlock.WhistleExtenderShape.SINGLE}).end().part().modelFile((ModelFile)double_).addModel()).condition(WhistleExtenderBlock.SIZE, (Comparable[])new WhistleBlock.WhistleSize[]{size}).condition(WhistleExtenderBlock.SHAPE, (Comparable[])new WhistleExtenderBlock.WhistleExtenderShape[]{WhistleExtenderBlock.WhistleExtenderShape.DOUBLE, WhistleExtenderBlock.WhistleExtenderShape.DOUBLE_CONNECTED}).end();
            }
        };
    }

    public static <P extends FluidPipeBlock> NonNullBiConsumer<DataGenContext<class_2248, P>, RegistrateBlockstateProvider> pipe() {
        return (c, p) -> {
            String path = "block/" + c.getName();
            String LU = "lu";
            String RU = "ru";
            String LD = "ld";
            String RD = "rd";
            String LR = "lr";
            String UD = "ud";
            String U = "u";
            String D = "d";
            String L = "l";
            String R = "r";
            ImmutableList orientations = ImmutableList.of((Object)LU, (Object)RU, (Object)LD, (Object)RD, (Object)LR, (Object)UD, (Object)U, (Object)D, (Object)L, (Object)R);
            ImmutableMap uvs = ImmutableMap.builder().put((Object)LU, (Object)Pair.of((Object)12, (Object)4)).put((Object)RU, (Object)Pair.of((Object)8, (Object)4)).put((Object)LD, (Object)Pair.of((Object)12, (Object)0)).put((Object)RD, (Object)Pair.of((Object)8, (Object)0)).put((Object)LR, (Object)Pair.of((Object)4, (Object)8)).put((Object)UD, (Object)Pair.of((Object)0, (Object)8)).put((Object)U, (Object)Pair.of((Object)4, (Object)4)).put((Object)D, (Object)Pair.of((Object)0, (Object)0)).put((Object)L, (Object)Pair.of((Object)4, (Object)0)).put((Object)R, (Object)Pair.of((Object)0, (Object)4)).build();
            IdentityHashMap<class_2350.class_2351, class_2960> coreTemplates = new IdentityHashMap<class_2350.class_2351, class_2960>();
            HashMap<Pair<String, class_2350.class_2351>, ModelFile> coreModels = new HashMap<Pair<String, class_2350.class_2351>, ModelFile>();
            for (class_2350.class_2351 axis : Iterate.axes) {
                coreTemplates.put(axis, p.modLoc(path + "/core_" + axis.method_15434()));
            }
            for (class_2350.class_2351 axis : Iterate.axes) {
                class_2960 parent = (class_2960)coreTemplates.get(axis);
                for (String s : orientations) {
                    Pair key = Pair.of((Object)s, (Object)axis);
                    String modelName = path + "/" + s + "_" + axis.method_15434();
                    coreModels.put((Pair<String, class_2350.class_2351>)key, (ModelFile)((BlockModelBuilder)p.models().withExistingParent(modelName, parent)).element().from(4.0f, 4.0f, 4.0f).to(12.0f, 12.0f, 12.0f).face(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis)).end().face(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11060, (class_2350.class_2351)axis)).end().faces((arg_0, arg_1) -> BlockStateGen.lambda$pipe$28((Map)uvs, s, arg_0, arg_1)).end());
                }
            }
            MultiPartBlockStateBuilder builder = p.getMultipartBuilder((class_2248)c.get());
            for (class_2350.class_2351 axis : Iterate.axes) {
                BlockStateGen.putPart(coreModels, builder, axis, LU, true, false, true, false);
                BlockStateGen.putPart(coreModels, builder, axis, RU, true, false, false, true);
                BlockStateGen.putPart(coreModels, builder, axis, LD, false, true, true, false);
                BlockStateGen.putPart(coreModels, builder, axis, RD, false, true, false, true);
                BlockStateGen.putPart(coreModels, builder, axis, UD, true, true, false, false);
                BlockStateGen.putPart(coreModels, builder, axis, U, true, false, false, false);
                BlockStateGen.putPart(coreModels, builder, axis, D, false, true, false, false);
                BlockStateGen.putPart(coreModels, builder, axis, LR, false, false, true, true);
                BlockStateGen.putPart(coreModels, builder, axis, L, false, false, true, false);
                BlockStateGen.putPart(coreModels, builder, axis, R, false, false, false, true);
            }
        };
    }

    private static void putPart(Map<Pair<String, class_2350.class_2351>, ModelFile> coreModels, MultiPartBlockStateBuilder builder, class_2350.class_2351 axis, String s, boolean up, boolean down, boolean left, boolean right) {
        class_2350 positiveAxis = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
        Map propertyMap = FluidPipeBlock.field_11329;
        class_2350 upD = Pointing.UP.getCombinedDirection(positiveAxis);
        class_2350 leftD = Pointing.LEFT.getCombinedDirection(positiveAxis);
        class_2350 rightD = Pointing.RIGHT.getCombinedDirection(positiveAxis);
        class_2350 downD = Pointing.DOWN.getCombinedDirection(positiveAxis);
        if (axis == class_2350.class_2351.field_11052 || axis == class_2350.class_2351.field_11048) {
            leftD = leftD.method_10153();
            rightD = rightD.method_10153();
        }
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(coreModels.get(Pair.of((Object)s, (Object)axis))).addModel()).condition((class_2769)propertyMap.get(upD), (Comparable[])new Boolean[]{up}).condition((class_2769)propertyMap.get(leftD), (Comparable[])new Boolean[]{left}).condition((class_2769)propertyMap.get(rightD), (Comparable[])new Boolean[]{right}).condition((class_2769)propertyMap.get(downD), (Comparable[])new Boolean[]{down}).end();
    }

    public static Function<class_2680, ConfiguredModel[]> mapToAir(@NonnullType RegistrateBlockstateProvider p) {
        return state -> ConfiguredModel.builder().modelFile((ModelFile)p.models().getExistingFile(p.mcLoc("block/air"))).build();
    }

    private static /* synthetic */ void lambda$pipe$28(Map uvs, String s, class_2350 d, ModelBuilder.ElementBuilder.FaceBuilder builder) {
        Pair pair = (Pair)uvs.get(s);
        float u = ((Integer)pair.getKey()).intValue();
        float v = ((Integer)pair.getValue()).intValue();
        if (d == class_2350.field_11036) {
            builder.uvs(u + 4.0f, v + 4.0f, u, v);
        }
        if (d == class_2350.field_11033) {
            builder.uvs(u + 4.0f, v, u, v + 4.0f);
        }
        if (d == class_2350.field_11043) {
            builder.uvs(u, v, u + 4.0f, v + 4.0f);
        }
        if (d == class_2350.field_11035) {
            builder.uvs(u + 4.0f, v, u, v + 4.0f);
        }
        if (d == class_2350.field_11034) {
            builder.uvs(u, v, u + 4.0f, v + 4.0f);
        }
        if (d == class_2350.field_11039) {
            builder.uvs(u + 4.0f, v, u, v + 4.0f);
        }
        builder.texture("#0");
    }
}

