/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.block;

import com.simibubi.create.foundation.block.CopperRegistries;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import io.github.fabricators_of_create.porting_lib.mixin.common.accessor.StairBlockAccessor;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2450;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4970;
import net.minecraft.class_5812;
import net.minecraft.class_5813;
import net.minecraft.class_5814;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraftforge.client.model.generators.ModelFile;
import org.apache.commons.lang3.ArrayUtils;

public class CopperBlockSet {
    protected static final class_5955.class_5811[] WEATHER_STATES = class_5955.class_5811.values();
    protected static final int WEATHER_STATE_COUNT = WEATHER_STATES.length;
    protected static final Map<class_5955.class_5811, class_2248> BASE_BLOCKS = new EnumMap<class_5955.class_5811, class_2248>(class_5955.class_5811.class);
    public static final Variant<?>[] DEFAULT_VARIANTS;
    protected final String name;
    protected final String generalDirectory;
    protected final Variant<?>[] variants;
    protected final Map<Variant<?>, BlockEntry<?>[]> entries = new HashMap();
    protected final NonNullBiConsumer<DataGenContext<class_2248, ?>, RegistrateRecipeProvider> mainBlockRecipe;
    protected final String endTextureName;

    public CopperBlockSet(AbstractRegistrate<?> registrate, String name, String endTextureName, Variant<?>[] variants) {
        this(registrate, name, endTextureName, variants, NonNullBiConsumer.noop(), "copper/");
    }

    public CopperBlockSet(AbstractRegistrate<?> registrate, String name, String endTextureName, Variant<?>[] variants, String generalDirectory) {
        this(registrate, name, endTextureName, variants, NonNullBiConsumer.noop(), generalDirectory);
    }

    public CopperBlockSet(AbstractRegistrate<?> registrate, String name, String endTextureName, Variant<?>[] variants, NonNullBiConsumer<DataGenContext<class_2248, ?>, RegistrateRecipeProvider> mainBlockRecipe) {
        this(registrate, name, endTextureName, variants, mainBlockRecipe, "copper/");
    }

    public CopperBlockSet(AbstractRegistrate<?> registrate, String name, String endTextureName, Variant<?>[] variants, NonNullBiConsumer<DataGenContext<class_2248, ?>, RegistrateRecipeProvider> mainBlockRecipe, String generalDirectory) {
        this.name = name;
        this.generalDirectory = generalDirectory;
        this.endTextureName = endTextureName;
        this.variants = variants;
        this.mainBlockRecipe = mainBlockRecipe;
        for (boolean waxed : Iterate.falseAndTrue) {
            for (Variant<?> variant : this.variants) {
                BlockEntry[] entries = waxed ? this.entries.get(variant) : new BlockEntry[WEATHER_STATE_COUNT * 2];
                for (class_5955.class_5811 state : WEATHER_STATES) {
                    BlockEntry<?> entry;
                    int index = this.getIndex(state, waxed);
                    entries[index] = entry = this.createEntry(registrate, variant, state, waxed);
                    if (waxed) {
                        CopperRegistries.addWaxable(() -> (class_2248)entries[this.getIndex(state, false)].get(), () -> (class_2248)entry.get());
                        continue;
                    }
                    if (state == class_5955.class_5811.field_28704) continue;
                    CopperRegistries.addWeathering(() -> (class_2248)entries[this.getIndex(WEATHER_STATES[state.ordinal() - 1], false)].get(), () -> (class_2248)entry.get());
                }
                if (waxed) continue;
                this.entries.put(variant, entries);
            }
        }
    }

    protected <T extends class_2248> BlockEntry<?> createEntry(AbstractRegistrate<?> registrate, Variant<T> variant, class_5955.class_5811 state, boolean waxed) {
        Object name = "";
        if (waxed) {
            name = (String)name + "waxed_";
        }
        name = (String)name + CopperBlockSet.getWeatherStatePrefix(state);
        name = (String)name + this.name;
        String suffix = variant.getSuffix();
        if (!suffix.equals("")) {
            name = Lang.nonPluralId((String)name);
        }
        name = (String)name + suffix;
        class_2248 baseBlock = BASE_BLOCKS.get(state);
        BlockBuilder builder = ((BlockBuilder)registrate.block((String)name, variant.getFactory(this, state, waxed)).initialProperties(() -> baseBlock).loot((lt, block) -> variant.generateLootTable((RegistrateBlockLootTables)lt, (Object)block, this, state, waxed)).blockstate((ctx, prov) -> variant.generateBlockState((DataGenContext)ctx, (RegistrateBlockstateProvider)prov, this, state, waxed)).recipe((c, p) -> variant.generateRecipes(this.entries.get(BlockVariant.INSTANCE)[state.ordinal()], (DataGenContext)c, (RegistrateRecipeProvider)p)).transform(TagGen.pickaxeOnly())).tag(new class_6862[]{class_3481.field_33719}).simpleItem();
        if (variant == BlockVariant.INSTANCE && state == class_5955.class_5811.field_28704) {
            builder.recipe((c, p) -> this.mainBlockRecipe.accept(c, p));
        }
        if (waxed) {
            builder.recipe((ctx, prov) -> {
                class_2248 unwaxed = (class_2248)this.get(variant, state, false).get();
                class_2450.method_10447((class_1935)((class_1935)ctx.get())).method_10454((class_1935)unwaxed).method_10454((class_1935)class_1802.field_20414).method_10442("has_unwaxed", (class_184)RegistrateRecipeProvider.has((class_1935)unwaxed)).method_17972((Consumer)prov, new class_2960(ctx.getId().method_12836(), "crafting/" + this.generalDirectory + ctx.getName() + "_from_honeycomb"));
            });
        }
        return builder.register();
    }

    protected int getIndex(class_5955.class_5811 state, boolean waxed) {
        return state.ordinal() + (waxed ? WEATHER_STATE_COUNT : 0);
    }

    public String getName() {
        return this.name;
    }

    public String getEndTextureName() {
        return this.endTextureName;
    }

    public Variant<?>[] getVariants() {
        return this.variants;
    }

    public boolean hasVariant(Variant<?> variant) {
        return ArrayUtils.contains((Object[])this.variants, variant);
    }

    public BlockEntry<?> get(Variant<?> variant, class_5955.class_5811 state, boolean waxed) {
        BlockEntry<?>[] entries = this.entries.get(variant);
        if (entries != null) {
            return entries[this.getIndex(state, waxed)];
        }
        return null;
    }

    public BlockEntry<?> getStandard() {
        return this.get(BlockVariant.INSTANCE, class_5955.class_5811.field_28704, false);
    }

    public static String getWeatherStatePrefix(class_5955.class_5811 state) {
        if (state != class_5955.class_5811.field_28704) {
            return state.name().toLowerCase(Locale.ROOT) + "_";
        }
        return "";
    }

    static {
        BASE_BLOCKS.put(class_5955.class_5811.field_28704, class_2246.field_27119);
        BASE_BLOCKS.put(class_5955.class_5811.field_28705, class_2246.field_27118);
        BASE_BLOCKS.put(class_5955.class_5811.field_28706, class_2246.field_27117);
        BASE_BLOCKS.put(class_5955.class_5811.field_28707, class_2246.field_27116);
        DEFAULT_VARIANTS = new Variant[]{BlockVariant.INSTANCE, SlabVariant.INSTANCE, StairVariant.INSTANCE};
    }

    public static interface Variant<T extends class_2248> {
        public String getSuffix();

        public NonNullFunction<class_4970.class_2251, T> getFactory(CopperBlockSet var1, class_5955.class_5811 var2, boolean var3);

        default public void generateLootTable(RegistrateBlockLootTables lootTable, T block, CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            lootTable.method_16329(block);
        }

        public void generateRecipes(BlockEntry<?> var1, DataGenContext<class_2248, T> var2, RegistrateRecipeProvider var3);

        public void generateBlockState(DataGenContext<class_2248, T> var1, RegistrateBlockstateProvider var2, CopperBlockSet var3, class_5955.class_5811 var4, boolean var5);
    }

    public static class BlockVariant
    implements Variant<class_2248> {
        public static final BlockVariant INSTANCE = new BlockVariant();

        protected BlockVariant() {
        }

        @Override
        public String getSuffix() {
            return "";
        }

        @Override
        public NonNullFunction<class_4970.class_2251, class_2248> getFactory(CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            if (waxed) {
                return class_2248::new;
            }
            return p -> new class_5812(state, p);
        }

        @Override
        public void generateBlockState(DataGenContext<class_2248, class_2248> ctx, RegistrateBlockstateProvider prov, CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            class_2248 block = (class_2248)ctx.get();
            String path = RegisteredObjects.getKeyOrThrow(block).method_12832();
            String baseLoc = "block/" + blocks.generalDirectory + CopperBlockSet.getWeatherStatePrefix(state);
            class_2960 texture = prov.modLoc(baseLoc + blocks.getName());
            if (Objects.equals(blocks.getName(), blocks.getEndTextureName())) {
                prov.simpleBlock(block, (ModelFile)prov.models().cubeAll(path, texture));
            } else {
                class_2960 endTexture = prov.modLoc(baseLoc + blocks.getEndTextureName());
                prov.simpleBlock(block, (ModelFile)prov.models().cubeColumn(path, texture, endTexture));
            }
        }

        @Override
        public void generateRecipes(BlockEntry<?> blockVariant, DataGenContext<class_2248, class_2248> ctx, RegistrateRecipeProvider prov) {
        }
    }

    public static class SlabVariant
    implements Variant<class_2482> {
        public static final SlabVariant INSTANCE = new SlabVariant();

        protected SlabVariant() {
        }

        @Override
        public String getSuffix() {
            return "_slab";
        }

        @Override
        public NonNullFunction<class_4970.class_2251, class_2482> getFactory(CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            if (waxed) {
                return class_2482::new;
            }
            return p -> new class_5813(state, p);
        }

        @Override
        public void generateLootTable(RegistrateBlockLootTables lootTable, class_2482 block, CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            lootTable.method_16258((class_2248)block, RegistrateBlockLootTables.createSlabItemTable((class_2248)block));
        }

        @Override
        public void generateBlockState(DataGenContext<class_2248, class_2482> ctx, RegistrateBlockstateProvider prov, CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            class_2960 fullModel = prov.modLoc("block/" + CopperBlockSet.getWeatherStatePrefix(state) + blocks.getName());
            String baseLoc = "block/" + blocks.generalDirectory + CopperBlockSet.getWeatherStatePrefix(state);
            class_2960 texture = prov.modLoc(baseLoc + blocks.getName());
            class_2960 endTexture = prov.modLoc(baseLoc + blocks.getEndTextureName());
            prov.slabBlock((class_2482)ctx.get(), fullModel, texture, endTexture, endTexture);
        }

        @Override
        public void generateRecipes(BlockEntry<?> blockVariant, DataGenContext<class_2248, class_2482> ctx, RegistrateRecipeProvider prov) {
            prov.slab(DataIngredient.items((class_1935)((class_2248)blockVariant.get()), (class_1935[])new class_2248[0]), () -> ctx.get(), null, true);
        }
    }

    public static class StairVariant
    implements Variant<class_2510> {
        public static final StairVariant INSTANCE = new StairVariant(BlockVariant.INSTANCE);
        protected final Variant<?> parent;

        protected StairVariant(Variant<?> parent) {
            this.parent = parent;
        }

        @Override
        public String getSuffix() {
            return "_stairs";
        }

        @Override
        public NonNullFunction<class_4970.class_2251, class_2510> getFactory(CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            if (!blocks.hasVariant(this.parent)) {
                throw new IllegalStateException("Cannot add StairVariant '" + this.toString() + "' without parent Variant '" + this.parent.toString() + "'!");
            }
            Supplier<class_2680> defaultStateSupplier = () -> blocks.get(this.parent, state, waxed).getDefaultState();
            if (waxed) {
                return p -> StairBlockAccessor.port_lib$init((class_2680)((class_2680)defaultStateSupplier.get()), (class_4970.class_2251)p);
            }
            return p -> {
                class_5814 block = new class_5814(state, class_2246.field_10124.method_9564(), p);
                return block;
            };
        }

        @Override
        public void generateBlockState(DataGenContext<class_2248, class_2510> ctx, RegistrateBlockstateProvider prov, CopperBlockSet blocks, class_5955.class_5811 state, boolean waxed) {
            String baseLoc = "block/" + blocks.generalDirectory + CopperBlockSet.getWeatherStatePrefix(state);
            class_2960 texture = prov.modLoc(baseLoc + blocks.getName());
            class_2960 endTexture = prov.modLoc(baseLoc + blocks.getEndTextureName());
            prov.stairsBlock((class_2510)ctx.get(), texture, endTexture, endTexture);
        }

        @Override
        public void generateRecipes(BlockEntry<?> blockVariant, DataGenContext<class_2248, class_2510> ctx, RegistrateRecipeProvider prov) {
            prov.stairs(DataIngredient.items((class_1935)((class_2248)blockVariant.get()), (class_1935[])new class_2248[0]), () -> ctx.get(), null, true);
        }
    }
}

